"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),init_1=require("../init");class author extends sequelize_1.Model{static initModel(e){return author.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the blog author"},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,unique:"authorUserIdFkey",validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}},comment:"ID of the user who is applying to become a blog author"},status:{type:sequelize_1.DataTypes.ENUM("PENDING","APPROVED","REJECTED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","APPROVED","REJECTED"]],msg:"status: Must be either 'PENDING', 'APPROVED', or 'REJECTED'"}},comment:"Current status of the author application (PENDING, APPROVED, REJECTED)"}},{sequelize:e,modelName:"author",tableName:"author",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"authorIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"authorUserIdKey",unique:!0,using:"BTREE",fields:[{name:"userId"}]}],hooks:{...(0,init_1.createUserCacheHooks)()}})}static associate(e){author.hasMany(e.post,{as:"posts",foreignKey:"authorId",onDelete:"CASCADE",onUpdate:"CASCADE"});author.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=author;