"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class post extends sequelize_1.Model{static initModel(e){return post.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the blog post"},title:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"title: Title cannot be empty"}},comment:"Title of the blog post"},content:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"content: Content cannot be empty"}},comment:"Full content/body of the blog post"},categoryId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"categoryId: Category ID must be a valid UUID"}},comment:"ID of the category this post belongs to"},authorId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"authorId: Author ID must be a valid UUID"}},comment:"ID of the author who wrote this post"},slug:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,unique:"postSlugKey",validate:{notEmpty:{msg:"slug: Slug cannot be empty"}},comment:"URL-friendly slug for the post (used in URLs)"},description:{type:sequelize_1.DataTypes.TEXT("long"),allowNull:!0,comment:"Brief description or excerpt of the post"},status:{type:sequelize_1.DataTypes.ENUM("PUBLISHED","DRAFT"),allowNull:!1,defaultValue:"DRAFT",validate:{isIn:{args:[["PUBLISHED","DRAFT"]],msg:"status: Status must be either PUBLISHED, or DRAFT"}},comment:"Publication status of the post (PUBLISHED or DRAFT)"},image:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"URL path to the featured image for the post"},views:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,defaultValue:0,comment:"Number of times this post has been viewed"}},{sequelize:e,modelName:"post",tableName:"post",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"postSlugKey",unique:!0,using:"BTREE",fields:[{name:"slug"}]},{name:"postsCategoryIdForeign",using:"BTREE",fields:[{name:"categoryId"}]},{name:"postsAuthorIdForeign",using:"BTREE",fields:[{name:"authorId"}]}]})}static associate(e){post.belongsTo(e.author,{as:"author",foreignKey:"authorId",onDelete:"CASCADE",onUpdate:"CASCADE"});post.belongsTo(e.category,{as:"category",foreignKey:"categoryId",onDelete:"CASCADE",onUpdate:"CASCADE"});post.hasMany(e.comment,{as:"comments",foreignKey:"postId",onDelete:"CASCADE",onUpdate:"CASCADE"});post.hasMany(e.postTag,{as:"postTags",foreignKey:"postId",onDelete:"CASCADE",onUpdate:"CASCADE"});post.belongsToMany(e.tag,{through:e.postTag,as:"tags",foreignKey:"postId",otherKey:"tagId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=post;