"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class ecosystemCustodialWallet extends sequelize_1.Model{static initModel(e){return ecosystemCustodialWallet.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},masterWalletId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"masterWalletId: Master Wallet ID cannot be null"},isUUID:{args:4,msg:"masterWalletId: Master Wallet ID must be a valid UUID"}}},address:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,unique:"ecosystemCustodialWalletAddressKey",validate:{notEmpty:{msg:"address: Address must not be empty"}}},chain:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"chain: Chain must not be empty"}}},network:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,defaultValue:"mainnet",validate:{notEmpty:{msg:"network: Network must not be empty"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","INACTIVE","SUSPENDED"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","INACTIVE","SUSPENDED"]],msg:"status: Status must be either 'ACTIVE', 'INACTIVE', or 'SUSPENDED'"}}}},{sequelize:e,modelName:"ecosystemCustodialWallet",tableName:"ecosystem_custodial_wallet",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecosystemCustodialWalletIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"ecosystemCustodialWalletAddressKey",unique:!0,using:"BTREE",fields:[{name:"address"}]},{name:"custodialWalletMasterWalletIdIdx",using:"BTREE",fields:[{name:"masterWalletId"}]}]})}static associate(e){ecosystemCustodialWallet.belongsTo(e.ecosystemMasterWallet,{as:"masterWallet",foreignKey:"masterWalletId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=ecosystemCustodialWallet;