"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class forexInvestment extends sequelize_1.Model{static initModel(e){return forexInvestment.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},planId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"planId: Plan ID must be a valid UUID"}}},durationId:{type:sequelize_1.DataTypes.UUID,allowNull:!0,validate:{isUUID:{args:4,msg:"durationId: Duration ID must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"amount: Amount must be a number"}}},profit:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!0,validate:{isFloat:{msg:"profit: Profit must be a number"}}},result:{type:sequelize_1.DataTypes.ENUM("WIN","LOSS","DRAW"),allowNull:!0,validate:{isIn:{args:[["WIN","LOSS","DRAW"]],msg:"result: Result must be WIN, LOSS, or DRAW"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","COMPLETED","CANCELLED","REJECTED"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","COMPLETED","CANCELLED","REJECTED"]],msg:"status: Status must be ACTIVE, COMPLETED, CANCELLED, or REJECTED"}}},endDate:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0},metadata:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},termsAcceptedAt:{type:sequelize_1.DataTypes.DATE(3),allowNull:!0,validate:{isDate:{msg:"termsAcceptedAt: Must be a valid date",args:!0}}},termsVersion:{type:sequelize_1.DataTypes.STRING(50),allowNull:!0,validate:{notEmpty:{msg:"termsVersion: Terms version must not be empty"}}}},{sequelize:e,modelName:"forexInvestment",tableName:"forex_investment",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"forexInvestmentIdKey",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"forexInvestmentUserIdFkey",using:"BTREE",fields:[{name:"userId"}]},{name:"forexInvestmentPlanIdFkey",using:"BTREE",fields:[{name:"planId"}]},{name:"forexInvestmentDurationIdFkey",using:"BTREE",fields:[{name:"durationId"}]},{name:"forexInvestmentStatusIndex",unique:!1,using:"BTREE",fields:["userId","planId","status"],where:{status:"ACTIVE"}},{name:"forexInvestmentUserIdStatusIdx",using:"BTREE",fields:[{name:"userId"},{name:"status"}]},{name:"forexInvestmentCreatedAtIdx",using:"BTREE",fields:[{name:"createdAt"}]},{name:"forexInvestmentEndDateIdx",using:"BTREE",fields:[{name:"endDate"}]}]})}static associate(e){forexInvestment.belongsTo(e.forexPlan,{as:"plan",foreignKey:"planId",onDelete:"CASCADE",onUpdate:"CASCADE"});forexInvestment.belongsTo(e.forexDuration,{as:"duration",foreignKey:"durationId",onDelete:"CASCADE",onUpdate:"CASCADE"});forexInvestment.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=forexInvestment;