"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayRefund extends sequelize_1.Model{static initModel(e){return gatewayRefund.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},paymentId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"paymentId: Must be a valid UUID"}}},merchantId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"merchantId: Must be a valid UUID"}}},transactionId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},refundId:{type:sequelize_1.DataTypes.STRING(64),allowNull:!1},amount:{type:sequelize_1.DataTypes.DECIMAL(30,8),allowNull:!1,validate:{min:{args:[.01],msg:"amount: Must be greater than 0"}},get(){const e=this.getDataValue("amount");return e?parseFloat(e.toString()):0}},currency:{type:sequelize_1.DataTypes.STRING(20),allowNull:!1},reason:{type:sequelize_1.DataTypes.ENUM("REQUESTED_BY_CUSTOMER","DUPLICATE","FRAUDULENT","OTHER"),allowNull:!1,defaultValue:"REQUESTED_BY_CUSTOMER"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},status:{type:sequelize_1.DataTypes.ENUM("PENDING","COMPLETED","FAILED","CANCELLED"),allowNull:!1,defaultValue:"PENDING"},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return"string"==typeof e?JSON.parse(e):e}}},{sequelize:e,modelName:"gatewayRefund",tableName:"gateway_refund",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayRefundIdUnique",unique:!0,using:"BTREE",fields:[{name:"refundId"}]},{name:"gatewayRefundPaymentIdFkey",using:"BTREE",fields:[{name:"paymentId"}]},{name:"gatewayRefundMerchantIdFkey",using:"BTREE",fields:[{name:"merchantId"}]},{name:"gatewayRefundTransactionIdFkey",using:"BTREE",fields:[{name:"transactionId"}]},{name:"gatewayRefundStatusIdx",using:"BTREE",fields:[{name:"status"}]}]})}static associate(e){gatewayRefund.belongsTo(e.gatewayPayment,{as:"payment",foreignKey:"paymentId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayRefund.belongsTo(e.gatewayMerchant,{as:"merchant",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayRefund.belongsTo(e.transaction,{as:"transaction",foreignKey:"transactionId",onDelete:"SET NULL",onUpdate:"CASCADE"});gatewayRefund.hasMany(e.gatewayWebhook,{as:"gatewayWebhooks",foreignKey:"refundId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=gatewayRefund;