"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class gatewayWebhook extends sequelize_1.Model{static initModel(e){return gatewayWebhook.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},merchantId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{isUUID:{args:4,msg:"merchantId: Must be a valid UUID"}}},paymentId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},refundId:{type:sequelize_1.DataTypes.UUID,allowNull:!0},eventType:{type:sequelize_1.DataTypes.STRING(100),allowNull:!1,validate:{isIn:{args:[["payment.created","payment.completed","payment.failed","payment.cancelled","payment.expired","refund.created","refund.completed","refund.failed"]],msg:"eventType: Must be a valid webhook event type"}}},url:{type:sequelize_1.DataTypes.STRING(1e3),allowNull:!1,validate:{isUrl:{msg:"url: Must be a valid URL"}}},payload:{type:sequelize_1.DataTypes.JSON,allowNull:!1,get(){const e=this.getDataValue("payload");return"string"==typeof e?JSON.parse(e):e}},signature:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1},status:{type:sequelize_1.DataTypes.ENUM("PENDING","SENT","FAILED","RETRYING"),allowNull:!1,defaultValue:"PENDING"},attempts:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0},maxAttempts:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:5},lastAttemptAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},nextRetryAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},responseStatus:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0},responseBody:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},responseTime:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0},errorMessage:{type:sequelize_1.DataTypes.TEXT,allowNull:!0}},{sequelize:e,modelName:"gatewayWebhook",tableName:"gateway_webhook",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"gatewayWebhookMerchantIdFkey",using:"BTREE",fields:[{name:"merchantId"}]},{name:"gatewayWebhookPaymentIdFkey",using:"BTREE",fields:[{name:"paymentId"}]},{name:"gatewayWebhookRefundIdFkey",using:"BTREE",fields:[{name:"refundId"}]},{name:"gatewayWebhookStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"gatewayWebhookNextRetryIdx",using:"BTREE",fields:[{name:"nextRetryAt"}]}]})}static associate(e){gatewayWebhook.belongsTo(e.gatewayMerchant,{as:"merchant",foreignKey:"merchantId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayWebhook.belongsTo(e.gatewayPayment,{as:"payment",foreignKey:"paymentId",onDelete:"CASCADE",onUpdate:"CASCADE"});gatewayWebhook.belongsTo(e.gatewayRefund,{as:"refund",foreignKey:"refundId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=gatewayWebhook;