"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class nftRoyalty extends sequelize_1.Model{static initModel(e){return nftRoyalty.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},saleId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"saleId: Sale ID cannot be null"},isUUID:{args:4,msg:"saleId: Sale ID must be a valid UUID"}}},tokenId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"tokenId: Token ID cannot be null"},isUUID:{args:4,msg:"tokenId: Token ID must be a valid UUID"}}},collectionId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"collectionId: Collection ID cannot be null"},isUUID:{args:4,msg:"collectionId: Collection ID must be a valid UUID"}}},recipientId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"recipientId: Recipient ID cannot be null"},isUUID:{args:4,msg:"recipientId: Recipient ID must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.DECIMAL(36,18),allowNull:!1,validate:{min:{args:[0],msg:"amount: Amount must be non-negative"}}},percentage:{type:sequelize_1.DataTypes.DECIMAL(5,2),allowNull:!1,validate:{min:{args:[0],msg:"percentage: Percentage must be non-negative"},max:{args:[100],msg:"percentage: Percentage cannot exceed 100%"}}},currency:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency must not be empty"}}},transactionHash:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,validate:{is:{args:/^0x[a-fA-F0-9]{64}$/,msg:"transactionHash: Invalid transaction hash format"}}},blockNumber:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,validate:{min:{args:[0],msg:"blockNumber: Block number must be non-negative"}}},status:{type:sequelize_1.DataTypes.ENUM("PENDING","PAID","FAILED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","PAID","FAILED"]],msg:"status: Status must be one of 'PENDING', 'PAID', or 'FAILED'"}}},paidAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0},metadata:{type:sequelize_1.DataTypes.JSON,allowNull:!0,get(){const e=this.getDataValue("metadata");return e?JSON.parse(e):null},set(e){this.setDataValue("metadata",JSON.stringify(e))}}},{sequelize:e,modelName:"nftRoyalty",tableName:"nft_royalty",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"nftRoyaltySaleIdx",using:"BTREE",fields:[{name:"saleId"}]},{name:"nftRoyaltyTokenIdx",using:"BTREE",fields:[{name:"tokenId"}]},{name:"nftRoyaltyCollectionIdx",using:"BTREE",fields:[{name:"collectionId"}]},{name:"nftRoyaltyRecipientIdx",using:"BTREE",fields:[{name:"recipientId"}]},{name:"nftRoyaltyStatusIdx",using:"BTREE",fields:[{name:"status"}]},{name:"nftRoyaltyCreatedAtIdx",using:"BTREE",fields:[{name:"createdAt"}]}]})}static associate(e){nftRoyalty.belongsTo(e.nftSale,{as:"sale",foreignKey:"saleId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftRoyalty.belongsTo(e.nftToken,{as:"token",foreignKey:"tokenId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftRoyalty.belongsTo(e.nftCollection,{as:"collection",foreignKey:"collectionId",onDelete:"CASCADE",onUpdate:"CASCADE"});nftRoyalty.belongsTo(e.user,{as:"recipient",foreignKey:"recipientId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=nftRoyalty;