"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class stakingPool extends sequelize_1.Model{static initModel(e){return stakingPool.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},name:{type:sequelize_1.DataTypes.STRING(191),allowNull:!1,validate:{notEmpty:{msg:"name: Pool name must not be empty"},len:{args:[2,100],msg:"name: Length must be between 2 and 100 characters"}}},token:{type:sequelize_1.DataTypes.STRING(50),allowNull:!1,validate:{notEmpty:{msg:"token: Token name must not be empty"}}},symbol:{type:sequelize_1.DataTypes.STRING(10),allowNull:!1,validate:{notEmpty:{msg:"symbol: Symbol must not be empty"},len:{args:[1,10],msg:"symbol: Length must be between 1 and 10 characters"}}},icon:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"description: Description must not be empty"}}},walletType:{type:sequelize_1.DataTypes.ENUM("FIAT","SPOT","ECO"),allowNull:!1,defaultValue:"SPOT",validate:{isIn:{args:[["FIAT","SPOT","ECO"]],msg:"walletType: Must be one of: FIAT, SPOT, ECO"}}},walletChain:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0},apr:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"apr: Must be a valid number"},min:{args:[0],msg:"apr: Cannot be negative"}}},lockPeriod:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,validate:{isInt:{msg:"lockPeriod: Must be an integer"},min:{args:[0],msg:"lockPeriod: Cannot be negative"}}},minStake:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"minStake: Must be a valid number"},min:{args:[0],msg:"minStake: Cannot be negative"}}},maxStake:{type:sequelize_1.DataTypes.FLOAT,allowNull:!0,validate:{isFloat:{msg:"maxStake: Must be a valid number"},min:{args:[0],msg:"maxStake: Cannot be negative"},isGreaterThanMinStake(e){if(null!==e&&e<=this.minStake)throw new Error("maxStake: Must be greater than minStake")}}},availableToStake:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"availableToStake: Must be a valid number"},min:{args:[0],msg:"availableToStake: Cannot be negative"}}},earlyWithdrawalFee:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"earlyWithdrawalFee: Must be a valid number"},min:{args:[0],msg:"earlyWithdrawalFee: Cannot be negative"},max:{args:[100],msg:"earlyWithdrawalFee: Cannot exceed 100%"}}},adminFeePercentage:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,defaultValue:0,validate:{isFloat:{msg:"adminFeePercentage: Must be a valid number"},min:{args:[0],msg:"adminFeePercentage: Cannot be negative"},max:{args:[100],msg:"adminFeePercentage: Cannot exceed 100%"}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","INACTIVE","COMING_SOON"),allowNull:!1,defaultValue:"INACTIVE",validate:{isIn:{args:[["ACTIVE","INACTIVE","COMING_SOON"]],msg:"status: Must be one of: ACTIVE, INACTIVE, COMING_SOON"}}},isPromoted:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},order:{type:sequelize_1.DataTypes.INTEGER,allowNull:!1,defaultValue:0,validate:{isInt:{msg:"order: Must be an integer"},min:{args:[0],msg:"order: Cannot be negative"}}},earningFrequency:{type:sequelize_1.DataTypes.ENUM("DAILY","WEEKLY","MONTHLY","END_OF_TERM"),allowNull:!1,defaultValue:"DAILY",validate:{isIn:{args:[["DAILY","WEEKLY","MONTHLY","END_OF_TERM"]],msg:"earningFrequency: Must be one of: DAILY, WEEKLY, MONTHLY, END_OF_TERM"}}},autoCompound:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},externalPoolUrl:{type:sequelize_1.DataTypes.STRING(191),allowNull:!0,validate:{isValidOptionalUrl(e){if(e&&""!==e.trim()){if(!/^https?:\/\/.+/i.test(e))throw new Error("externalPoolUrl: Must be a valid URL")}}}},profitSource:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"profitSource: Profit source must not be empty"}}},fundAllocation:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"fundAllocation: Fund allocation must not be empty"}}},risks:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"risks: Risks must not be empty"}}},rewards:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{notEmpty:{msg:"rewards: Rewards must not be empty"}}}},{sequelize:e,modelName:"stakingPool",tableName:"staking_pools",paranoid:!0,timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"staking_pools_token_idx",fields:[{name:"token"}]},{name:"staking_pools_status_idx",fields:[{name:"status"}]},{name:"staking_pools_order_idx",fields:[{name:"order"}]}]})}static associate(e){stakingPool.hasMany(e.stakingPosition,{foreignKey:"poolId",as:"positions",onDelete:"CASCADE",onUpdate:"CASCADE"});stakingPool.hasMany(e.stakingAdminEarning,{foreignKey:"poolId",as:"adminEarnings",onDelete:"CASCADE",onUpdate:"CASCADE"});stakingPool.hasMany(e.stakingExternalPoolPerformance,{foreignKey:"poolId",as:"performances",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=stakingPool;