"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class stakingPosition extends sequelize_1.Model{static initModel(e){return stakingPosition.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"},isUUID:{args:4,msg:"userId: User ID must be a valid UUID"}}},poolId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"poolId: Pool ID cannot be null"},isUUID:{args:4,msg:"poolId: Must be a valid UUID"}}},amount:{type:sequelize_1.DataTypes.FLOAT,allowNull:!1,validate:{isFloat:{msg:"amount: Must be a valid number"},min:{args:[0],msg:"amount: Cannot be negative"},isValidAmount(e){if(e<=0)throw new Error("amount: Must be greater than 0")}}},startDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1,validate:{isDate:{msg:"startDate: Must be a valid date",args:!0},isBeforeEndDate(e){if(new Date(e)>=new Date(this.endDate))throw new Error("startDate: Must be before end date")}}},endDate:{type:sequelize_1.DataTypes.DATE,allowNull:!1,validate:{isDate:{msg:"endDate: Must be a valid date",args:!0}}},status:{type:sequelize_1.DataTypes.ENUM("ACTIVE","COMPLETED","CANCELLED","PENDING_WITHDRAWAL"),allowNull:!1,defaultValue:"ACTIVE",validate:{isIn:{args:[["ACTIVE","COMPLETED","CANCELLED","PENDING_WITHDRAWAL"]],msg:"status: Must be one of: ACTIVE, COMPLETED, CANCELLED, PENDING_WITHDRAWAL"}}},withdrawalRequested:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1},withdrawalRequestDate:{type:sequelize_1.DataTypes.DATE,allowNull:!0,validate:{isDate:{msg:"withdrawalRequestDate: Must be a valid date",args:!0},isValidWithdrawalDate(e){if(e&&!this.withdrawalRequested)throw new Error("withdrawalRequestDate: Cannot set withdrawal date when withdrawal is not requested")}}},adminNotes:{type:sequelize_1.DataTypes.TEXT,allowNull:!0},completedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,validate:{isDate:{msg:"completedAt: Must be a valid date",args:!0},isValidCompletionDate(e){if(e&&"COMPLETED"!==this.status)throw new Error("completedAt: Cannot set completion date when status is not COMPLETED")}}}},{sequelize:e,modelName:"stakingPosition",tableName:"staking_positions",paranoid:!0,timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,fields:[{name:"id"}]},{name:"staking_positions_user_idx",fields:[{name:"userId"}]},{name:"staking_positions_pool_idx",fields:[{name:"poolId"}]},{name:"staking_positions_status_idx",fields:[{name:"status"}]},{name:"staking_positions_withdrawal_idx",fields:[{name:"withdrawalRequested"}]},{name:"staking_positions_user_status_idx",fields:[{name:"userId"},{name:"status"}]},{name:"staking_positions_end_date_idx",fields:[{name:"endDate"}]},{name:"staking_positions_created_idx",fields:[{name:"createdAt"}]}]})}static associate(e){stakingPosition.belongsTo(e.stakingPool,{foreignKey:"poolId",as:"pool",onDelete:"CASCADE",onUpdate:"CASCADE"});stakingPosition.hasMany(e.stakingEarningRecord,{foreignKey:"positionId",as:"earningHistory",onDelete:"CASCADE",onUpdate:"CASCADE"});stakingPosition.belongsTo(e.user,{foreignKey:"userId",as:"user",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=stakingPosition;