"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class adminProfit extends sequelize_1.Model{static initModel(e){return adminProfit.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},transactionId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"transactionId: Transaction ID cannot be null"},isUUID:{args:4,msg:"transactionId: Transaction ID must be a valid UUID"}},comment:"ID of the transaction that generated this profit"},type:{type:sequelize_1.DataTypes.ENUM("DEPOSIT","WITHDRAW","TRANSFER","BINARY_ORDER","EXCHANGE_ORDER","INVESTMENT","AI_INVESTMENT","FOREX_DEPOSIT","FOREX_WITHDRAW","FOREX_INVESTMENT","ICO_CONTRIBUTION","STAKING","P2P_TRADE","NFT_SALE","NFT_AUCTION","NFT_OFFER","GATEWAY_PAYMENT"),allowNull:!1,validate:{isIn:{args:[["DEPOSIT","WITHDRAW","TRANSFER","BINARY_ORDER","EXCHANGE_ORDER","INVESTMENT","AI_INVESTMENT","FOREX_DEPOSIT","FOREX_WITHDRAW","FOREX_INVESTMENT","ICO_CONTRIBUTION","STAKING","P2P_TRADE","NFT_SALE","NFT_AUCTION","NFT_OFFER","GATEWAY_PAYMENT"]],msg:"type: Type must be one of the defined transaction types"}},comment:"Type of transaction that generated the admin profit"},amount:{type:sequelize_1.DataTypes.DOUBLE,allowNull:!1,validate:{isFloat:{msg:"amount: Amount must be a number"}},comment:"Profit amount earned by admin from this transaction"},currency:{type:sequelize_1.DataTypes.STRING(255),allowNull:!1,validate:{notEmpty:{msg:"currency: Currency cannot be empty"}},comment:"Currency of the profit amount"},chain:{type:sequelize_1.DataTypes.STRING(255),allowNull:!0,comment:"Blockchain network if applicable"},description:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Additional description of the profit source"}},{sequelize:e,modelName:"adminProfit",tableName:"admin_profit",timestamps:!0,paranoid:!1,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"adminProfitTransactionIdForeign",using:"BTREE",fields:[{name:"transactionId"}]}]})}static associate(e){adminProfit.belongsTo(e.transaction,{as:"transaction",foreignKey:"transactionId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=adminProfit;