"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize"),init_1=require("../init");class kycApplication extends sequelize_1.Model{static initModel(e){return kycApplication.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1,comment:"Unique identifier for the KYC application"},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"userId: User ID cannot be null"}},comment:"ID of the user submitting the KYC application"},levelId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,validate:{notNull:{msg:"levelId: Level ID cannot be null"}},comment:"ID of the KYC level being applied for"},status:{type:sequelize_1.DataTypes.ENUM("PENDING","APPROVED","REJECTED","ADDITIONAL_INFO_REQUIRED"),allowNull:!1,defaultValue:"PENDING",validate:{isIn:{args:[["PENDING","APPROVED","REJECTED","ADDITIONAL_INFO_REQUIRED"]],msg:"status: Invalid status value"}},comment:"Current status of the KYC application review process"},data:{type:sequelize_1.DataTypes.JSON,allowNull:!1,comment:"KYC application data including documents and personal information"},adminNotes:{type:sequelize_1.DataTypes.TEXT,allowNull:!0,comment:"Notes added by admin during KYC review process"},reviewedAt:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Date and time when the application was reviewed by admin"}},{sequelize:e,modelName:"kycApplication",tableName:"kyc_application",timestamps:!0,paranoid:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]}],hooks:{...(0,init_1.createUserCacheHooks)()}})}static associate(e){kycApplication.belongsTo(e.kycLevel,{as:"level",foreignKey:"levelId",onDelete:"CASCADE",onUpdate:"CASCADE"});kycApplication.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE"});kycApplication.hasOne(e.kycVerificationResult,{as:"verificationResult",foreignKey:"applicationId",onDelete:"CASCADE",onUpdate:"CASCADE"})}}exports.default=kycApplication;