"use strict";Object.defineProperty(exports,"__esModule",{value:!0});const sequelize_1=require("sequelize");class userBlock extends sequelize_1.Model{static initModel(e){return userBlock.init({id:{type:sequelize_1.DataTypes.UUID,defaultValue:sequelize_1.DataTypes.UUIDV4,primaryKey:!0,allowNull:!1},userId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,comment:"ID of the user being blocked"},adminId:{type:sequelize_1.DataTypes.UUID,allowNull:!1,comment:"ID of the admin who created this block"},reason:{type:sequelize_1.DataTypes.TEXT,allowNull:!1,validate:{len:{args:[1,1e3],msg:"reason: Reason must be between 1 and 1000 characters"}},comment:"Reason for blocking the user"},isTemporary:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!1,comment:"Whether this is a temporary or permanent block"},duration:{type:sequelize_1.DataTypes.INTEGER,allowNull:!0,validate:{min:{args:[1],msg:"duration: Duration must be at least 1 hour"},max:{args:[8760],msg:"duration: Duration cannot exceed 1 year"}},comment:"Block duration in hours (for temporary blocks)"},blockedUntil:{type:sequelize_1.DataTypes.DATE,allowNull:!0,comment:"Date and time when the block expires"},isActive:{type:sequelize_1.DataTypes.BOOLEAN,allowNull:!1,defaultValue:!0,comment:"Whether this block is currently active"}},{sequelize:e,modelName:"userBlock",tableName:"user_blocks",timestamps:!0,indexes:[{name:"PRIMARY",unique:!0,using:"BTREE",fields:[{name:"id"}]},{name:"user_blocks_userId_idx",using:"BTREE",fields:[{name:"userId"}]},{name:"user_blocks_adminId_idx",using:"BTREE",fields:[{name:"adminId"}]},{name:"user_blocks_isActive_idx",using:"BTREE",fields:[{name:"isActive"}]}]})}static associate(e){userBlock.belongsTo(e.user,{as:"user",foreignKey:"userId",onDelete:"CASCADE",onUpdate:"CASCADE",constraints:!1});userBlock.belongsTo(e.user,{as:"admin",foreignKey:"adminId",onDelete:"CASCADE",onUpdate:"CASCADE",constraints:!1})}}exports.default=userBlock;