"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get affiliate dashboard analytics and metrics",description:"Retrieves comprehensive affiliate dashboard data including total affiliates, referrals, earnings metrics with month-over-month comparisons, conversion rates, monthly earnings chart data for the last 12 months, affiliate status distribution, and top-performing affiliates ranked by earnings.",operationId:"getAffiliateDashboard",tags:["Admin","Affiliate","Dashboard"],requiresAuth:!0,permission:"access.affiliate",responses:{200:{description:"Affiliate dashboard data retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{metrics:{type:"object",description:"Key performance metrics with month-over-month changes",properties:{totalAffiliates:{type:"object",properties:{value:{type:"integer",description:"Total number of unique affiliates (referrers)"},change:{type:"string",description:"Percentage change compared to previous month"},trend:{type:"string",enum:["up","down"],description:"Trend direction"}},required:["value","change","trend"]},totalReferrals:{type:"object",properties:{value:{type:"integer",description:"Total number of referrals"},change:{type:"string",description:"Percentage change compared to previous month"},trend:{type:"string",enum:["up","down"],description:"Trend direction"}},required:["value","change","trend"]},totalEarnings:{type:"object",properties:{value:{type:"number",format:"float",description:"Total earnings across all affiliates"},change:{type:"string",description:"Percentage change compared to previous month"},trend:{type:"string",enum:["up","down"],description:"Trend direction"}},required:["value","change","trend"]},conversionRate:{type:"object",properties:{value:{type:"integer",description:"Current month conversion rate percentage"},change:{type:"string",description:"Percentage point change compared to previous month"},trend:{type:"string",enum:["up","down"],description:"Trend direction"}},required:["value","change","trend"]}},required:["totalAffiliates","totalReferrals","totalEarnings","conversionRate"]},charts:{type:"object",description:"Chart data for visualizations",properties:{monthlyEarnings:{type:"array",description:"Monthly earnings data for the last 12 months",items:{type:"object",properties:{month:{type:"string",description:"Month in YYYY-MM format"},amount:{type:"number",format:"float",description:"Total earnings for the month"}},required:["month","amount"]}},affiliateStatus:{type:"array",description:"Distribution of affiliates by status",items:{type:"object",properties:{status:{type:"string",description:"Affiliate status"},count:{type:"integer",description:"Number of affiliates with this status"}},required:["status","count"]}},topAffiliates:{type:"array",description:"Top performing affiliates ranked by earnings",items:{type:"object",properties:{id:{type:"string",description:"Affiliate user ID"},name:{type:"string",description:"Affiliate full name"},referrals:{type:"integer",description:"Total number of referrals"},earnings:{type:"number",format:"float",description:"Total earnings"},conversionRate:{type:"integer",description:"Conversion rate percentage"}},required:["id","name","referrals","earnings","conversionRate"]}}},required:["monthlyEarnings","affiliateStatus","topAffiliates"]}},required:["metrics","charts"]}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},logModule:"ADMIN_AFFILIATE",logTitle:"Get affiliate dashboard data"};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Admin privileges required."});null==t||t.step("Initializing dashboard metrics");const a=new Date,i=new Date(a.getFullYear(),a.getMonth(),1),n=new Date(a.getFullYear(),a.getMonth()-1,1),s=new Date(a.getFullYear(),a.getMonth(),0);null==t||t.step("Calculating total affiliates");const o=await db_1.models.mlmReferral.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("DISTINCT `referrerId`")),"totalAffiliates"]],raw:!0}),l=parseInt(o.totalAffiliates,10)||0,d=await db_1.models.mlmReferral.count(),u=await db_1.models.mlmReferral.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${i.toISOString()}' THEN 1 ELSE 0 END`)),"currentReferrals"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${s.toISOString()}' THEN 1 ELSE 0 END`)),"previousReferrals"]],raw:!0}),p=parseInt(u.currentReferrals,10)||0,f=parseInt(u.previousReferrals,10)||0,c=f>0?Math.round((p-f)/f*100):0,m=p>=f?"up":"down";null==t||t.step("Calculating total earnings");const g=await db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"totalEarnings"]],raw:!0}),h=parseFloat(g.totalEarnings)||0,w=await db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${i.toISOString()}' THEN reward ELSE 0 END`)),"currentEarnings"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${s.toISOString()}' THEN reward ELSE 0 END`)),"previousEarnings"]],raw:!0}),E=parseFloat(w.currentEarnings)||0,b=parseFloat(w.previousEarnings)||0,y=b>0?Math.round((E-b)/b*100):0,_=E>=b?"up":"down",q=(await db_1.models.mlmReferralReward.count(),await db_1.models.mlmReferralReward.findOne({attributes:[[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${i.toISOString()}' THEN 1 ELSE 0 END`)),"currentRewardCount"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${n.toISOString()}' AND '${s.toISOString()}' THEN 1 ELSE 0 END`)),"previousRewardCount"]],raw:!0})),A=parseInt(q.currentRewardCount,10)||0,S=parseInt(q.previousRewardCount,10)||0,v=d>0?Math.round(A/d*100):0,R=d>0?Math.round(S/d*100):0,I=R?v-R:0,z=v>=R?"up":"down";null==t||t.step("Aggregating dashboard metrics");const N={totalAffiliates:{value:l,change:`${c}`,trend:m},totalReferrals:{value:d,change:`${c}`,trend:m},totalEarnings:{value:h,change:`${y}`,trend:_},conversionRate:{value:v,change:`${I}`,trend:z}};null==t||t.step("Generating monthly earnings chart data");const T=[];for(let e=11;e>=0;e--){const r=new Date(a.getFullYear(),a.getMonth()-e,1);T.push(`${r.getFullYear()}-${String(r.getMonth()+1).padStart(2,"0")}`)}const M=(await db_1.models.mlmReferralReward.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),"%Y-%m"),"month"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"amount"]],where:{createdAt:{[sequelize_1.Op.gte]:new Date(a.getFullYear(),a.getMonth()-11,1)}},group:["month"],raw:!0})).reduce((e,r)=>{e[r.month]=parseFloat(r.amount);return e},{}),C=T.map(e=>({month:e,amount:M[e]||0}));null==t||t.step("Calculating affiliate status distribution");const D=(await db_1.models.mlmReferral.findAll({attributes:["status",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("*")),"count"]],group:["status"],raw:!0})).map(e=>({status:e.status,count:parseInt(e.count,10)}));null==t||t.step("Identifying top affiliates");const O=await db_1.models.mlmReferral.findAll({attributes:["referrerId",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("*")),"referrals"]],group:["referrerId"],raw:!0}),$=(await db_1.models.mlmReferralReward.findAll({attributes:["referrerId",[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("reward")),"earnings"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("*")),"rewardCount"]],group:["referrerId"],raw:!0})).reduce((e,r)=>{e[r.referrerId]={earnings:parseFloat(r.earnings),rewardCount:parseInt(r.rewardCount,10)};return e},{}),F=O.map(e=>e.referrerId),U=(await db_1.models.user.findAll({where:{id:F},attributes:["id","firstName","lastName"],raw:!0})).reduce((e,r)=>{e[r.id]=`${r.firstName||""} ${r.lastName||""}`.trim();return e},{}),j=O.map(e=>{const r=$[e.referrerId]||{earnings:0,rewardCount:0},t=e.referrals?Math.round(r.rewardCount/e.referrals*100):0;return{id:e.referrerId,name:U[e.referrerId]||e.referrerId,referrals:parseInt(e.referrals,10),earnings:r.earnings,conversionRate:t}}).sort((e,r)=>r.earnings-e.earnings);null==t||t.success("Dashboard data retrieved successfully");return{metrics:N,charts:{monthlyEarnings:C,affiliateStatus:D,topAffiliates:j}}};