"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"List all AI investment durations",operationId:"listAiInvestmentDurations",tags:["Admin","AI Investment","Duration"],description:"Retrieves a paginated list of all AI investment duration options. Supports filtering, sorting, and pagination for managing investment timeframes.",parameters:constants_1.crudParameters,responses:{200:{description:"List of AI investment durations with pagination information",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.aiInvestmentDurationSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("AI Investment Durations"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.ai.investment.duration",logModule:"ADMIN_AI",logTitle:"List investment durations"};exports.default=async t=>{var e;const{query:n,ctx:i}=t;null==i||i.step("Fetching investment durations");const s=await(0,query_1.getFiltered)({model:db_1.models.aiInvestmentDuration,query:n,sortField:n.sortField||"duration",paranoid:!1});null==i||i.success(`Retrieved ${(null===(e=s.items)||void 0===e?void 0:e.length)||0} duration(s)`);return s};