"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists all AI Investment Plans",operationId:"listAiInvestmentPlans",tags:["Admin","AI Investment","Plan"],description:"Retrieves a paginated list of all AI Investment Plans with support for filtering, sorting, and searching. Includes associated investments and durations for each plan.",parameters:constants_1.crudParameters,responses:{200:{description:"List of AI Investment Plans with detailed information including investments and durations, along with pagination metadata",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.aiInvestmentPlanSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("AI Investment Plans"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.ai.investment.plan",logModule:"ADMIN_AI",logTitle:"List investment plans"};exports.default=async e=>{var t;const{query:s,ctx:n}=e;null==n||n.step("Fetching investment plans");const a=await(0,query_1.getFiltered)({model:db_1.models.aiInvestmentPlan,query:s,sortField:s.sortField||"name",includeModels:[{model:db_1.models.aiInvestment,as:"investments",attributes:["id","amount","profit","status"]},{model:db_1.models.aiInvestmentDuration,as:"durations",through:{attributes:[]},attributes:["id","duration","timeframe"]}]});null==n||n.success(`Retrieved ${(null===(t=a.items)||void 0===t?void 0:t.length)||0} plan(s)`);return a};