"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.BotCoordinator=void 0;const BotManager_1=require("./BotManager"),console_1=require("@b/utils/console");class BotCoordinator{constructor(){this.marketRules=new Map;this.recentTrades=new Map;this.marketPressure=new Map;this.antiCollisionWindowMs=5e3;this.maxPressureImbalance=.3;this.recentTradeRetentionMs=6e4;this.botManager=BotManager_1.BotManager.getInstance()}static getInstance(){BotCoordinator.instance||(BotCoordinator.instance=new BotCoordinator);return BotCoordinator.instance}setMarketRules(e,r){this.marketRules.set(e,new Set(r));(0,console_1.logInfo)("bot-coordinator",`Set rules for market ${e}: ${r.join(", ")}`)}getMarketRules(e){return Array.from(this.marketRules.get(e)||[])}enableDefaultRules(e){this.setMarketRules(e,["ANTI_COLLISION","VOLUME_BALANCING","SPREAD_MAINTENANCE"])}coordinateTrade(e,r,t,s){const a=this.marketRules.get(e);if(!a||0===a.size||!t.shouldTrade)return{approved:!0};for(const n of a){const a=this.applyRule(n,e,r,t,s);if(!a.approved)return a;a.adjustedDecision&&(t=a.adjustedDecision)}return{approved:!0,adjustedDecision:t}}recordTrade(e,r,t,s,a){this.recentTrades.has(e)||this.recentTrades.set(e,[]);this.recentTrades.get(e).push({botId:r,side:t,price:s,amount:a,timestamp:Date.now()});this.updateMarketPressure(e,t,a);this.cleanOldTrades(e)}getMarketPressure(e){return this.marketPressure.get(e)}getRecommendedSide(e){const r=this.marketPressure.get(e);return r?r.netPressure>this.maxPressureImbalance?"SELL":r.netPressure<-this.maxPressureImbalance?"BUY":null:null}isSideAllowed(e,r){const t=this.marketPressure.get(e);return!t||!("BUY"===r&&t.netPressure>1.5*this.maxPressureImbalance)&&!("SELL"===r&&t.netPressure<1.5*-this.maxPressureImbalance)}getCoordinationStats(e){const r=this.getMarketRules(e),t=this.recentTrades.get(e)||[],s=this.marketPressure.get(e)||null,a=[];s&&(s.netPressure>this.maxPressureImbalance?a.push("High buy pressure - prioritize sell orders"):s.netPressure<-this.maxPressureImbalance?a.push("High sell pressure - prioritize buy orders"):a.push("Market pressure balanced"));return{activeRules:r,recentTradeCount:t.length,pressure:s,recommendations:a}}applyRule(e,r,t,s,a){switch(e){case"ANTI_COLLISION":return this.applyAntiCollision(r,t,s);case"PRICE_COORDINATION":return this.applyPriceCoordination(r,s,a);case"VOLUME_BALANCING":return this.applyVolumeBalancing(r,s);case"SPREAD_MAINTENANCE":return this.applySpreadMaintenance(r,s,a);default:return{approved:!0}}}applyAntiCollision(e,r,t){const s=this.recentTrades.get(e)||[],a=Date.now(),n=s.filter(e=>e.botId!==r&&e.side!==t.side&&a-e.timestamp<this.antiCollisionWindowMs);if(n.length>0){if(n.some(e=>"BUY"===t.side?t.price>=e.price:t.price<=e.price))return{approved:!1,reason:"Would collide with recent bot trade"}}return{approved:!0}}applyPriceCoordination(e,r,t){if(!r.price)return{approved:!0};const s=Number(t.currentPrice)/1e18,a=Number(r.price)/1e18;if(Math.abs((a-s)/s)>.01){const e=.01*s;let t;t="BUY"===r.side?BigInt(Math.floor(1e18*(s-e))):BigInt(Math.floor(1e18*(s+e)));return{approved:!0,adjustedDecision:{...r,price:t},reason:"Price adjusted to stay within coordination bounds"}}return{approved:!0}}applyVolumeBalancing(e,r){const t=this.marketPressure.get(e);if(!t)return{approved:!0};if("BUY"===r.side&&t.netPressure>this.maxPressureImbalance||"SELL"===r.side&&t.netPressure<-this.maxPressureImbalance){const e=r.amount?BigInt(Math.floor(.5*Number(r.amount))):void 0;return{approved:!0,adjustedDecision:{...r,amount:e},reason:"Order size reduced for volume balancing"}}return{approved:!0}}applySpreadMaintenance(e,r,t){var s,a;if(!r.price)return{approved:!0};const n=(null===(s=t.orderbook)||void 0===s?void 0:s.bestBid)||BigInt(0),o=(null===(a=t.orderbook)||void 0===a?void 0:a.bestAsk)||BigInt(0);if(n===BigInt(0)||o===BigInt(0))return{approved:!0};const i=Number(n),u=Number(o),d=Number(r.price);if("BUY"===r.side){const e=.999*u;if(d>e)return{approved:!0,adjustedDecision:{...r,price:BigInt(Math.floor(e))},reason:"Bid adjusted to maintain minimum spread"}}else{const e=1.001*i;if(d<e)return{approved:!0,adjustedDecision:{...r,price:BigInt(Math.floor(e))},reason:"Ask adjusted to maintain minimum spread"}}return{approved:!0}}updateMarketPressure(e,r,t){let s=this.marketPressure.get(e);s||(s={buyVolume:BigInt(0),sellVolume:BigInt(0),netPressure:0,lastUpdate:Date.now()});"BUY"===r?s.buyVolume+=t:s.sellVolume+=t;const a=Number(s.buyVolume)+Number(s.sellVolume);a>0&&(s.netPressure=(Number(s.buyVolume)-Number(s.sellVolume))/a);s.lastUpdate=Date.now();this.marketPressure.set(e,s)}cleanOldTrades(e){const r=this.recentTrades.get(e);if(!r)return;const t=Date.now()-this.recentTradeRetentionMs,s=r.filter(e=>e.timestamp>t);this.recentTrades.set(e,s)}resetMarketPressure(e){this.marketPressure.set(e,{buyVolume:BigInt(0),sellVolume:BigInt(0),netPressure:0,lastUpdate:Date.now()})}clearMarket(e){this.marketRules.delete(e);this.recentTrades.delete(e);this.marketPressure.delete(e)}}exports.BotCoordinator=BotCoordinator;exports.default=BotCoordinator;