"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.MarketManager=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),MarketInstance_1=require("./MarketInstance"),cache_1=require("@b/utils/cache");class MarketManager{constructor(e){this.markets=new Map;this.processingMarkets=new Set;this.BATCH_SIZE=5;this.BATCH_DELAY_MS=50;this.engine=e}async loadActiveMarkets(){try{const e=await db_1.models.aiMarketMaker.findAll({where:{status:"ACTIVE"},include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"}]});for(const r of e)await this.startMarket(r.id);return e.length}catch(e){console_1.logger.error("AI_MM","Market manager initialization error",e);throw e}}async startMarket(e){var r,t;try{const a="object"==typeof e&&null!==e,s=a?e.id:e;if(this.markets.has(s)){console_1.logger.warn("AI_MM",`Market ${s} is already running`);return!0}const o=this.engine.getConfig();if(this.markets.size>=o.maxConcurrentMarkets){console_1.logger.warn("AI_MM",`Max concurrent markets (${o.maxConcurrentMarkets}) reached`);return!1}let i=a?e:null;i||(i=await db_1.models.aiMarketMaker.findByPk(s,{include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"},{model:db_1.models.aiBot,as:"bots",where:{status:"ACTIVE"},required:!1}]}));if(!i){console_1.logger.error("AI_MM",`Market maker ${s} not found`);return!1}if(!i.market){console_1.logger.error("AI_MM",`Ecosystem market not found for ${s}`);return!1}const n=cache_1.CacheManager.getInstance(),l=Number(await n.getSetting("aiMarketMakerMinLiquidity"))||0,c=Number((null===(r=i.pool)||void 0===r?void 0:r.quoteCurrencyBalance)||0);if(l>0&&c<l){const e=`${i.market.currency}/${i.market.pair}`;console_1.logger.error("AI_MM",`Market ${e} does not meet minimum liquidity requirement. Required: ${l} ${i.market.pair}, Pool quote balance: ${c} ${i.market.pair}`);return!1}const M=new MarketInstance_1.MarketInstance(this.engine,i);await M.initialize();this.markets.set(s,M);const k=`${i.market.currency}/${i.market.pair}`;console_1.logger.info("AI_MM",`Started market: ${k||s}`);const u=(null===(t=i.pool)||void 0===t?void 0:t.totalValueLocked)||0;await this.logMarketHistory(s,"START",{symbol:k,targetPrice:i.targetPrice,realLiquidityPercent:i.realLiquidityPercent},Number(i.targetPrice),u);return!0}catch(e){console_1.logger.error("AI_MM","Market start error",e);return!1}}async stopMarket(e){try{const r=this.markets.get(e);if(!r){console_1.logger.warn("AI_MM",`Market ${e} is not running`);return!0}await r.cancelAllOrders();await r.shutdown();this.markets.delete(e);await db_1.models.aiMarketMaker.update({status:"STOPPED"},{where:{id:e}});console_1.logger.info("AI_MM",`Stopped market: ${e}`);await this.logMarketHistory(e,"STOP",{reason:"Manual stop"});return!0}catch(e){console_1.logger.error("AI_MM","Market stop error",e);return!1}}async pauseMarket(e){try{const r=this.markets.get(e);if(!r){console_1.logger.warn("AI_MM",`Market ${e} is not running`);return!1}await r.pause();await db_1.models.aiMarketMaker.update({status:"PAUSED"},{where:{id:e}});console_1.logger.info("AI_MM",`Paused market: ${e}`);await this.logMarketHistory(e,"PAUSE",{reason:"Manual pause"});return!0}catch(e){console_1.logger.error("AI_MM","Market pause error",e);return!1}}async resumeMarket(e){try{const r=this.markets.get(e);if(!r)return this.startMarket(e);await r.resume();await db_1.models.aiMarketMaker.update({status:"ACTIVE"},{where:{id:e}});console_1.logger.info("AI_MM",`Resumed market: ${e}`);await this.logMarketHistory(e,"RESUME",{});return!0}catch(e){console_1.logger.error("AI_MM","Market resume error",e);return!1}}async stopAllMarkets(){console_1.logger.info("AI_MM",`Stopping all ${this.markets.size} markets...`);const e=Array.from(this.markets.keys()).map(e=>this.stopMarket(e));await Promise.all(e)}async emergencyStopAllMarkets(){console_1.logger.error("AI_MM","Emergency stopping all markets!");for(const[e,r]of this.markets)try{await r.emergencyStop()}catch(r){console_1.logger.error("AI_MM",`Error emergency stopping market ${e}: ${r}`)}this.markets.clear();await db_1.models.aiMarketMaker.update({status:"STOPPED"},{where:{status:{[sequelize_1.Op.in]:["ACTIVE","PAUSED"]}}})}async processAllMarkets(){const e=[];for(const[r,t]of this.markets)this.processingMarkets.has(r)||"PAUSED"!==t.getStatus()&&e.push({id:r,instance:t});for(let r=0;r<e.length;r+=this.BATCH_SIZE){const t=e.slice(r,r+this.BATCH_SIZE).map(({id:e,instance:r})=>{this.processingMarkets.add(e);return r.process().catch(r=>{console_1.logger.error("AI_MM",`Market process error for ${e}`,r)}).finally(()=>{this.processingMarkets.delete(e)})});await Promise.all(t);r+this.BATCH_SIZE<e.length&&await new Promise(e=>setTimeout(e,this.BATCH_DELAY_MS))}}async cleanupExpiredOrders(){for(const[,e]of this.markets)try{await e.cleanupExpiredOrders()}catch(e){}}getMarketStatus(e){const r=this.markets.get(e);return r?r.getStatus():null}getActiveMarketCount(){return this.markets.size}getMarketIds(){return Array.from(this.markets.keys())}getMarketInstance(e){return this.markets.get(e)}async refreshAllMarkets(){console_1.logger.info("AI_MM","Refreshing all market configurations...");for(const[e,r]of this.markets)try{const t=await db_1.models.aiMarketMaker.findByPk(e,{include:[{model:db_1.models.aiMarketMakerPool,as:"pool"},{model:db_1.models.ecosystemMarket,as:"market"},{model:db_1.models.aiBot,as:"bots"}]});if(t){r.updateConfig(t);console_1.logger.info("AI_MM",`Refreshed config for market ${e}`)}}catch(r){console_1.logger.error("AI_MM",`Market refresh error for ${e}`,r)}}isMarketActive(e){return this.markets.has(e)}async logMarketHistory(e,r,t,a=0,s=0){try{await db_1.models.aiMarketMakerHistory.create({marketMakerId:e,action:r,details:t,priceAtAction:a,poolValueAtAction:s})}catch(e){}}}exports.MarketManager=MarketManager;exports.default=MarketManager;