"use strict";var __importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0});exports.PriceTracker=void 0;const console_1=require("@b/utils/console"),exchange_1=__importDefault(require("@b/utils/exchange")),redis_1=require("@b/utils/redis"),queries_1=require("../scylla/queries"),redis=redis_1.RedisSingleton.getInstance(),PRICE_CACHE_TTL=5;class PriceTracker{constructor(e,t){this.currentPrice=BigInt(0);this.priceHistory=[];this.volatility=0;this.lastFetchTime=null;this.high24h=BigInt(0);this.low24h=BigInt(0);this.volume24h=BigInt(0);this.symbolAvailableOnExchange=!0;this.exchangeCheckDone=!1;this.symbol=e;this.marketId=t}async initialize(){try{await this.loadPriceHistory();await this.fetchExternalPrice();console_1.logger.info("AI_MM",`PriceTracker initialized for ${this.symbol}`)}catch(e){console_1.logger.error("AI_MM","PriceTracker initialization error",e);throw e}}cleanup(){this.priceHistory=[]}async getCurrentPrice(){if(this.currentPrice>BigInt(0)&&this.lastFetchTime){if(Date.now()-this.lastFetchTime.getTime()<5e3)return this.currentPrice}return this.fetchExternalPrice()}async fetchExternalPrice(){var e;try{if(this.exchangeCheckDone&&!this.symbolAvailableOnExchange)return this.currentPrice;const e=await this.getCachedPrice();if(e>BigInt(0)){this.currentPrice=e;this.lastFetchTime=new Date;return e}const t=await exchange_1.default.startExchange();if(!t){this.symbolAvailableOnExchange=!1;this.exchangeCheckDone=!0;return this.currentPrice}if(!this.exchangeCheckDone)try{await t.loadMarkets();const e=t.markets;if(!e||!e[this.symbol]){this.symbolAvailableOnExchange=!1;this.exchangeCheckDone=!0;console_1.logger.info("AI_MM",`Symbol ${this.symbol} not available on exchange - using internal pricing only`);return this.currentPrice}this.exchangeCheckDone=!0}catch(e){this.symbolAvailableOnExchange=!1;this.exchangeCheckDone=!0;return this.currentPrice}if(!this.symbolAvailableOnExchange)return this.currentPrice;const i=await t.fetchTicker(this.symbol);if(i&&i.last){const e="number"==typeof i.last?i.last:parseFloat(i.last);this.currentPrice=BigInt(Math.floor(1e18*e));this.lastFetchTime=new Date;i.high&&(this.high24h=BigInt(Math.floor(1e18*parseFloat(i.high.toString()))));i.low&&(this.low24h=BigInt(Math.floor(1e18*parseFloat(i.low.toString()))));i.baseVolume&&(this.volume24h=BigInt(Math.floor(1e18*parseFloat(i.baseVolume.toString()))));await this.cachePrice(this.currentPrice);this.addToHistory(this.currentPrice);this.calculateVolatility();return this.currentPrice}return this.currentPrice}catch(t){const i=(null===(e=null==t?void 0:t.message)||void 0===e?void 0:e.toLowerCase())||"";if(i.includes("does not have market symbol")||i.includes("symbol not found")||i.includes("invalid symbol")||i.includes("market not found")){this.symbolAvailableOnExchange=!1;this.exchangeCheckDone=!0;console_1.logger.info("AI_MM",`Symbol ${this.symbol} not available on exchange - using internal pricing only`);return this.currentPrice}console_1.logger.error("AI_MM","External price fetch error",t);const r=await this.getInternalPrice();return r>BigInt(0)?r:this.currentPrice}}async getCachedPrice(){try{const e=`ai_market_maker:price:${this.symbol}`,t=await redis.get(e);if(t)return BigInt(t)}catch(e){}return BigInt(0)}async cachePrice(e){try{const t=`ai_market_maker:price:${this.symbol}`;await redis.set(t,e.toString(),"EX",5)}catch(e){}}async getInternalPrice(){try{const e=await(0,queries_1.getLatestPrice)(this.marketId);if(e)return e.price}catch(e){}return BigInt(0)}async loadPriceHistory(){try{const e=new Date,t=new Date(e.getTime()-36e5),i=await(0,queries_1.getPriceHistoryInRange)(this.marketId,t,e,100);this.priceHistory=i.map(e=>({price:e.price,timestamp:e.timestamp}));this.calculateVolatility()}catch(e){}}addToHistory(e){this.priceHistory.push({price:e,timestamp:new Date});this.priceHistory.length>100&&(this.priceHistory=this.priceHistory.slice(-100))}calculateVolatility(){if(this.priceHistory.length<2){this.volatility=0;return}const e=[];for(let t=1;t<this.priceHistory.length;t++){const i=Number(this.priceHistory[t-1].price),r=Number(this.priceHistory[t].price);i>0&&e.push((r-i)/i)}if(0===e.length){this.volatility=0;return}const t=e.reduce((e,t)=>e+t,0)/e.length,i=e.map(e=>Math.pow(e-t,2)).reduce((e,t)=>e+t,0)/e.length;this.volatility=100*Math.sqrt(i)}getVolatility(){return this.volatility}getPriceChange(e){if(this.priceHistory.length<2)return{absolute:BigInt(0),percent:0};const t=new Date(Date.now()-60*e*1e3),i=this.priceHistory.filter(e=>e.timestamp<=t);if(0===i.length)return{absolute:BigInt(0),percent:0};const r=i[i.length-1].price,s=this.currentPrice-r;return{absolute:s,percent:r>BigInt(0)?Number(s)/Number(r)*100:0}}isPriceInRange(e,t){return this.currentPrice>=e&&this.currentPrice<=t}get24hStats(){let e=0;this.low24h>BigInt(0)&&(e=Number(this.currentPrice-this.low24h)/Number(this.low24h)*100);return{high:this.high24h,low:this.low24h,volume:this.volume24h,change:e}}getPriceHistory(){return[...this.priceHistory]}getTimeSinceLastFetch(){return this.lastFetchTime?Date.now()-this.lastFetchTime.getTime():null}}exports.PriceTracker=PriceTracker;exports.default=PriceTracker;