"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.TradeExecutor=void 0;const console_1=require("@b/utils/console"),queries_1=require("../scylla/queries"),db_1=require("@b/db"),index_ws_1=require("../../market/index.ws"),uuid_1=require("uuid");class TradeExecutor{constructor(e,t){this.aiTradesExecuted=0;this.realOrdersPlaced=0;this.totalVolume=BigInt(0);this.config=e;this.orderManager=t}async executeAiTrade(e){try{const t=this.config.bots.filter(e=>"ACTIVE"===e.status);if(t.length<2){console_1.logger.warn("AI_MM",`Need at least 2 active bots for AI trades on ${this.config.symbol}`);return!1}const[i,o]=this.selectTradingBots(t,e.direction);if(!i||!o){console_1.logger.warn("AI_MM",`Cannot execute AI trade for ${this.config.symbol}: insufficient bots available (buyBot: ${i?"available":"null"}, sellBot: ${o?"available":"null"})`);return!1}if(i.id===o.id){console_1.logger.warn("AI_MM","Cannot execute AI trade: same bot selected for both sides");return!1}const r=e.targetPrice,a=BigInt(Math.floor(1e18*r)),d=Number(e.amount)/1e18,n=(0,uuid_1.v4)(),s=(0,uuid_1.v4)();await(0,queries_1.insertBotTrade)({marketId:this.config.marketId,buyBotId:i.id,sellBotId:o.id,buyOrderId:n,sellOrderId:s,price:a,amount:e.amount});await(0,queries_1.syncOrderbookFromAiTrade)(this.config.symbol,r,d,e.direction);await(0,queries_1.syncCandlesFromAiTrade)(this.config.symbol,r,d);await(0,queries_1.syncTradeToEcosystem)(this.config.symbol,r,d,e.direction);this.aiTradesExecuted++;this.totalVolume+=e.amount;await this.updateDatabaseStats(i.id,o.id,d,r);console_1.logger.debug("AI_MM",`AI trade executed: ${this.config.symbol} ${e.direction} ${d.toFixed(4)} @ ${r.toFixed(8)} | Buyer: ${i.name} | Seller: ${o.name}`);"development"===process.env.NODE_ENV&&console_1.logger.debug("AI_MM",`Broadcasting TRADE event for market ${this.config.id}`);(0,index_ws_1.broadcastAiMarketMakerEvent)(this.config.id,{type:"TRADE",data:{tradeId:n,symbol:this.config.symbol,side:e.direction,price:r,amount:d,buyBotId:i.id,buyBotName:i.name,sellBotId:o.id,sellBotName:o.name,timestamp:(new Date).toISOString()}});(0,index_ws_1.broadcastBotActivity)(this.config.id,{botId:i.id,botName:i.name,action:"AI_TRADE",details:{side:"BUY",price:r,amount:d,counterpartyBotId:o.id,counterpartyBotName:o.name}});(0,index_ws_1.broadcastBotActivity)(this.config.id,{botId:o.id,botName:o.name,action:"AI_TRADE",details:{side:"SELL",price:r,amount:d,counterpartyBotId:i.id,counterpartyBotName:i.name}});return!0}catch(e){console_1.logger.error("AI_MM","AI trade execution error",e);return!1}}async updateDatabaseStats(e,t,i,o){var r;try{const a=new Date,d=i*o,n=this.config.bots.find(t=>t.id===e);if(n){n.dailyTradeCount++;n.lastTradeAt=a}const s=this.config.bots.find(e=>e.id===t);if(s){s.dailyTradeCount++;s.lastTradeAt=a}this.config.currentDailyVolume+=i;await db_1.models.aiBot.increment({dailyTradeCount:1,totalVolume:d},{where:{id:e}});await db_1.models.aiBot.update({lastTradeAt:a},{where:{id:e}});await db_1.models.aiBot.increment({dailyTradeCount:1,totalVolume:d},{where:{id:t}});await db_1.models.aiBot.update({lastTradeAt:a},{where:{id:t}});await db_1.models.aiMarketMaker.increment("currentDailyVolume",{by:i,where:{id:this.config.id}});if(this.config.pool){}const l=(null===(r=this.config.pool)||void 0===r?void 0:r.totalValueLocked)||0;await db_1.models.aiMarketMakerHistory.create({marketMakerId:this.config.id,action:"TRADE",details:{botId:e,side:"BUY",amount:i,size:i,volume:i,price:o,triggeredBy:"SYSTEM"},priceAtAction:o,poolValueAtAction:l})}catch(e){console_1.logger.error("AI_MM","Stats update error",e)}}async placeRealLiquidityOrder(e){try{const t=this.config.bots.filter(e=>"ACTIVE"===e.status&&e.dailyTradeCount<e.maxDailyTrades);if(0===t.length){console_1.logger.debug("AI_MM",`Cannot place real order for ${this.config.symbol}: no bots available (all at daily limit or inactive)`);return!1}const i=t[Math.floor(Math.random()*t.length)],o=this.calculateDynamicSpread(e.direction,e.volatility),r=e.targetPrice*o,a=BigInt(Math.floor(1e18*r)),d=await this.orderManager.createOrder({botId:i.id,side:e.direction,type:"LIMIT",price:a,amount:e.amount,purpose:"LIQUIDITY",isRealLiquidity:!0});if(!d)return!1;this.realOrdersPlaced++;const n=Number(e.amount)/1e18;console_1.logger.debug("AI_MM",`Real liquidity order placed: ${this.config.symbol} ${e.direction} ${n.toFixed(4)} @ ${r.toFixed(8)}`);(0,index_ws_1.broadcastAiMarketMakerEvent)(this.config.id,{type:"ORDER",data:{orderId:d,symbol:this.config.symbol,side:e.direction,price:r,amount:n,botId:i.id,botName:i.name,orderType:"REAL_LIQUIDITY",timestamp:(new Date).toISOString()}});(0,index_ws_1.broadcastBotActivity)(this.config.id,{botId:i.id,botName:i.name,action:"REAL_ORDER_PLACED",details:{side:e.direction,price:r,amount:n,reason:"Providing real liquidity to ecosystem"}});return!0}catch(e){console_1.logger.error("AI_MM","Real liquidity order placement error",e);return!1}}calculateDynamicSpread(e,t){const i=t||0,o=.001+Math.min(5e-4*i,.005);return"BUY"===e?1-o:1+o}selectTradingBots(e,t){if(e.length<2)return[null,null];const i=e.filter(e=>e.dailyTradeCount<e.maxDailyTrades);if(i.length<2)return[null,null];const o=[...i].sort(()=>Math.random()-.5);let r=null,a=null;for(const e of o)if(r||!["ACCUMULATOR","SCALPER","MARKET_MAKER"].includes(e.personality)){!a&&e.id!==(null==r?void 0:r.id)&&["DISTRIBUTOR","SWING"].includes(e.personality)&&(a=e);if(r&&a)break}else r=e;if(!r||!a)for(const e of o)if(r){if(!a&&e.id!==r.id){a=e;break}}else r=e;return r&&a&&r.id!==a.id?[r,a]:[null,null]}determinePurpose(e){return"PRICE_PUSH"}addHumanBehavior(e,t){const i=Math.min(t.orderSizeVariance,.5),o=1-i+Math.random()*i*2;return BigInt(Math.floor(Number(e)*o))}getStats(){return{aiTradesExecuted:this.aiTradesExecuted,realOrdersPlaced:this.realOrdersPlaced,totalVolume:(Number(this.totalVolume)/1e18).toFixed(8)}}}exports.TradeExecutor=TradeExecutor;exports.default=TradeExecutor;