"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get Copy Trading Audit Logs",description:"Retrieves audit logs for copy trading with filtering and pagination. Supports filtering by entity type, entity ID, action, user ID, admin ID, and date range. Returns audit logs with associated user and admin information, plus action type counts for filtering.",operationId:"getAdminCopyTradingAuditLogs",tags:["Admin","Copy Trading","Audit"],requiresAuth:!0,logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Audit",permission:"access.copy_trading",demoMask:["items.user.email","items.admin.email"],parameters:[{name:"entityType",in:"query",required:!1,schema:{type:"string",enum:["LEADER","FOLLOWER","TRADE","TRANSACTION","SETTING"]},description:"Filter by entity type"},{name:"entityId",in:"query",required:!1,schema:{type:"string"},description:"Filter by entity ID"},{name:"action",in:"query",required:!1,schema:{type:"string"},description:"Filter by action type"},{name:"userId",in:"query",required:!1,schema:{type:"string"},description:"Filter by affected user ID"},{name:"adminId",in:"query",required:!1,schema:{type:"string"},description:"Filter by admin who performed action"},{name:"dateFrom",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter from date"},{name:"dateTo",in:"query",required:!1,schema:{type:"string",format:"date"},description:"Filter until date"},{name:"page",in:"query",required:!1,schema:{type:"integer",default:1}},{name:"limit",in:"query",required:!1,schema:{type:"integer",default:20}}],responses:{200:{description:"Audit logs retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",description:"List of audit logs",items:{type:"object",properties:{id:{type:"string"},entityType:{type:"string"},entityId:{type:"string"},action:{type:"string"},oldValue:{type:"object"},newValue:{type:"object"},metadata:{type:"object"},userId:{type:"string"},adminId:{type:"string"},createdAt:{type:"string",format:"date-time"},user:{type:"object"},admin:{type:"object"}}}},pagination:{type:"object",properties:{total:{type:"integer"},page:{type:"integer"},limit:{type:"integer"},totalPages:{type:"integer"}}},filters:{type:"object",properties:{actions:{type:"array",description:"Available action types with counts"}}}}}}}},401:errors_1.unauthorizedResponse,403:errors_1.forbiddenResponse,500:errors_1.serverErrorResponse}};exports.default=async e=>{const{user:t,query:i,ctx:r}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const a={};i.entityType&&(a.entityType=i.entityType);i.entityId&&(a.entityId=i.entityId);i.action&&(a.action=i.action);i.userId&&(a.userId=i.userId);i.adminId&&(a.adminId=i.adminId);if(i.dateFrom||i.dateTo){a.createdAt={};i.dateFrom&&(a.createdAt[sequelize_1.Op.gte]=new Date(i.dateFrom));i.dateTo&&(a.createdAt[sequelize_1.Op.lte]=new Date(i.dateTo+"T23:59:59.999Z"))}const n=parseInt(i.page)||1,s=Math.min(parseInt(i.limit)||20,100),o=(n-1)*s,{count:d,rows:u}=await db_1.models.copyTradingAuditLog.findAndCountAll({where:a,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email"],required:!1},{model:db_1.models.user,as:"admin",attributes:["id","firstName","lastName","email"],required:!1}],order:[["createdAt","DESC"]],limit:s,offset:o});null==r||r.step("Fetching audit logs");const p=await db_1.models.copyTradingAuditLog.findAll({attributes:["action",[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.col)("id")),"count"]],group:["action"]});null==r||r.success("Audit logs retrieved successfully");return{items:u.map(e=>{const t=e.toJSON();try{t.oldValue&&(t.oldValue=JSON.parse(t.oldValue));t.newValue&&(t.newValue=JSON.parse(t.newValue));t.metadata&&(t.metadata=JSON.parse(t.metadata))}catch(e){}return t}),pagination:{total:d,page:n,limit:s,totalPages:Math.ceil(d/s)},filters:{actions:p.map(e=>({action:e.action,count:parseInt(e.get("count"))}))}}};