"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),sequelize_1=require("sequelize"),stats_calculator_1=require("@b/api/(ext)/copy-trading/utils/stats-calculator");exports.metadata={summary:"List All Copy Trading Leaders (Admin)",description:"Retrieves all copy trading leaders with filtering options.",operationId:"adminListCopyTradingLeaders",tags:["Admin","Copy Trading"],requiresAuth:!0,logModule:"ADMIN_COPY",logTitle:"Get Copy Trading Leaders",permission:"access.copy_trading",demoMask:["items.user.email"],parameters:[{name:"status",in:"query",schema:{type:"string"},description:"Filter by status (comma-separated)"},{name:"search",in:"query",schema:{type:"string"},description:"Search by display name or email"},{name:"page",in:"query",schema:{type:"number"}},{name:"limit",in:"query",schema:{type:"number"}}],responses:{200:{description:"Leaders retrieved successfully"},401:{description:"Unauthorized"},403:{description:"Forbidden"},500:{description:"Internal Server Error"}}};exports.default=async e=>{const{query:t,ctx:a}=e;null==a||a.step("Get Copy Trading Leaders");const s={},r={};if(t.status){const e=t.status.split(",");s.status={[sequelize_1.Op.in]:e}}if(t.search){const e=`%${t.search}%`;s[sequelize_1.Op.or]=[{displayName:{[sequelize_1.Op.like]:e}}];r[sequelize_1.Op.or]=[{email:{[sequelize_1.Op.like]:e}},{firstName:{[sequelize_1.Op.like]:e}},{lastName:{[sequelize_1.Op.like]:e}}]}const i=parseInt(t.page)||1,l=Math.min(parseInt(t.limit)||20,100),d=(i-1)*l,{count:n,rows:o}=await db_1.models.copyTradingLeader.findAndCountAll({where:s,include:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"],where:t.search?r:void 0,required:!!t.search},{model:db_1.models.copyTradingLeaderMarket,as:"markets",required:!1}],order:[["createdAt","DESC"]],limit:l,offset:d});null==a||a.step("Calculating stats for leaders");const u=o.map(e=>e.id),c=await(0,stats_calculator_1.calculateBatchLeaderStats)(u),p=o.map(e=>({...e.toJSON(),...c.get(e.id)}));null==a||a.success("Get Copy Trading Leaders retrieved successfully");return{items:p,pagination:{total:n,page:i,limit:l,totalPages:Math.ceil(n/l)}}};