"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"Lists all ecommerce discounts with pagination and filtering",operationId:"listEcommerceDiscounts",description:"Retrieves a paginated list of all ecommerce discounts with their associated product information. Supports filtering, sorting, and searching capabilities. Returns discount codes, percentages, validity dates, and linked product details including category information.",tags:["Admin","Ecommerce","Discount"],parameters:constants_1.crudParameters,responses:{200:{description:"List of ecommerce discounts with product details and pagination metadata",content:{"application/json":{schema:{type:"object",properties:{data:{type:"array",items:{type:"object",properties:utils_1.ecommerceDiscountSchema}},pagination:constants_1.paginationSchema}}}}},401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Ecommerce Discounts"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"view.ecommerce.discount",logModule:"ADMIN_ECOM",logTitle:"List discounts"};exports.default=async e=>{var t;const{query:s,ctx:r}=e;null==r||r.step("Parsing query parameters");null==r||r.step("Fetching discounts from database");const i=await(0,query_1.getFiltered)({model:db_1.models.ecommerceDiscount,query:s,sortField:s.sortField||"validUntil",numericFields:["percentage"],includeModels:[{model:db_1.models.ecommerceProduct,as:"product",attributes:["id","image","name"],includeModels:[{model:db_1.models.ecommerceCategory,as:"category",attributes:["name"]}]}]});null==r||r.success(`Retrieved ${(null===(t=i.items)||void 0===t?void 0:t.length)||0} discounts`);return i};