"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const errors_1=require("@b/utils/schema/errors"),error_1=require("@b/utils/error"),db_1=require("@b/db");exports.metadata={summary:"Get available blockchain options",description:"Retrieves a list of supported blockchain options for the ecosystem. Returns a static list of EVM-compatible chains (Arbitrum, Base, BSC, Celo, Ethereum, Fantom, Optimism, Polygon, RSK) and conditionally includes Solana and Mo Chain if they are enabled in the database.",operationId:"getEcosystemBlockchainOptions",tags:["Admin","Ecosystem","Blockchain"],requiresAuth:!0,logModule:"ADMIN_ECO",logTitle:"Get blockchain options",responses:{200:{description:"Blockchain options retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{id:{type:"string",description:"Blockchain chain identifier",example:"ETH"},name:{type:"string",description:"Blockchain display name with symbol",example:"Ethereum (ETH)"}},required:["id","name"]}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ecosystem.blockchain"};exports.default=async e=>{const{user:i,ctx:t}=e;if(!(null==i?void 0:i.id))throw(0,error_1.createError)(401,"Unauthorized");try{null==t||t.step("Retrieving blockchain statuses");const e=await db_1.models.ecosystemBlockchain.findAll({where:{chain:["SOL","MO"]}}),i=e.find(e=>"SOL"===e.chain&&e.status),o=e.find(e=>"MO"===e.chain&&e.status);null==t||t.step("Building blockchain options list");const r=[{id:"ARBITRUM",name:"Arbitrum (ARB)"},{id:"BASE",name:"Base (BASE)"},{id:"BSC",name:"Binance Smart Chain (BSC)"},{id:"CELO",name:"Celo (CELO)"},{id:"ETH",name:"Ethereum (ETH)"},{id:"FTM",name:"Fantom (FTM)"},{id:"OPTIMISM",name:"Optimism (OVM)"},{id:"POLYGON",name:"Polygon (MATIC)"},{id:"RSK",name:"RSK (RSK)"},...i?[{id:"SOL",name:"Solana (SOL)"}]:[],...o?[{id:"MO",name:"Mo Chain (MO)"}]:[]];null==t||t.success("Blockchain options retrieved successfully");return r}catch(e){null==t||t.fail(e.message);throw(0,error_1.createError)(500,"An error occurred while fetching blockchain options")}};