"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),encrypt_1=require("@b/utils/encrypt"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Set Hardware Security Module (HSM) passphrase",description:"Sets or updates the passphrase for Hardware Security Module (HSM) operations used in the ecosystem. This passphrase is used for encrypting sensitive data such as private keys and wallet information. Only administrators with ecosystem access can perform this action.",operationId:"setEcosystemKmsPassphrase",tags:["Admin","Ecosystem","KMS"],logModule:"ADMIN_ECO",logTitle:"Set HSM passphrase",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{passphrase:{type:"string",description:"The passphrase to set for the HSM encryption operations (required)"}},required:["passphrase"]}}}},responses:{200:(0,errors_1.successMessageResponse)("Encryption key set successfully"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"access.ecosystem"};exports.default=async e=>{const{body:s,ctx:r}=e,{passphrase:t}=s;if(!t)throw(0,error_1.createError)({statusCode:400,message:"Passphrase is required"});null==r||r.step("Setting encryption key");if(await(0,encrypt_1.setEncryptionKey)(t)){null==r||r.success("Encryption key set successfully");return{message:"Encryption key set successfully."}}null==r||r.fail("Failed to set encryption key");throw(0,error_1.createError)({statusCode:500,message:"Failed to set encryption key"})};