"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"Imports an existing ecosystem token",description:"Imports an existing token by providing contract details, network information, and token metadata. This endpoint is used to add already-deployed tokens to the platform without deploying a new contract.",operationId:"importEcosystemToken",tags:["Admin","Ecosystem","Token"],logModule:"ADMIN_ECO",logTitle:"Import token",requestBody:{required:!0,content:{"application/json":{schema:utils_1.ecosystemTokenImportSchema}}},responses:{200:{description:"Ecosystem token imported successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},record:{type:"object",properties:{id:{type:"string",description:"Token ID"},contract:{type:"string",description:"Contract address"},name:{type:"string",description:"Token name"},currency:{type:"string",description:"Token currency symbol"},chain:{type:"string",description:"Blockchain chain"},network:{type:"string",description:"Network type"},type:{type:"string",description:"Token type"},decimals:{type:"number",description:"Token decimals"},contractType:{type:"string",enum:["PERMIT","NO_PERMIT","NATIVE"],description:"Contract type"},status:{type:"boolean",description:"Token status"}}}}}}}},400:errors_1.badRequestResponse,401:query_1.unauthorizedResponse,409:(0,errors_1.conflictResponse)("Ecosystem Token"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"create.ecosystem.token"};exports.default=async e=>{const{body:t,ctx:o}=e,{icon:r,name:s,currency:n,chain:i,network:c,contract:a,contractType:p,decimals:d,precision:l,type:u,fee:y,limits:m,status:k}=t;try{null==o||o.step("Sanitizing token data");const e={icon:r,name:s,currency:n,chain:i,network:c,contract:a,contractType:p,decimals:d,precision:l,type:u,fee:"object"==typeof y?JSON.stringify(y):y,limits:"object"==typeof m?JSON.stringify(m):m,status:k};null==o||o.step("Importing token to database");const t=await(0,query_1.storeRecord)({model:"ecosystemToken",data:e,returnResponse:!0});if(t.record&&r)try{await(0,utils_1.updateIconInCache)(n,r,o)}catch(e){null==o||o.warn(`Failed to update icon in cache: ${e.message}`);console.error(`Failed to update icon in cache for ${n}:`,e)}null==o||o.success(`Token ${n} imported successfully`);return t}catch(e){null==o||o.fail(e.message);console.error("Error importing ecosystem token:",e);"SequelizeValidationError"===e.name?console.error("Validation failed for one or more fields."):"SequelizeDatabaseError"===e.name&&console.error("Database error occurred.");throw e}};