"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils"),tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),safe_imports_1=require("@b/utils/safe-imports"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),wallet_1=require("@b/api/(ext)/ecosystem/utils/wallet"),task_1=require("@b/utils/task"),db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Deploys a new ecosystem token",description:"Deploys a new token contract on the blockchain and registers it in the platform. Supports both ERC20 tokens (EVM chains) and SPL tokens (Solana). The token is deployed using the master wallet and initial supply is minted to the specified holder.",operationId:"deployEcosystemToken",tags:["Admin","Ecosystem","Token"],logModule:"ADMIN_ECO",logTitle:"Deploy token",requestBody:{required:!0,content:{"application/json":{schema:utils_1.ecosystemTokenDeploySchema}}},responses:{200:{description:"Ecosystem token deployed successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"},record:{type:"object",properties:{id:{type:"string",description:"Token ID"},contract:{type:"string",description:"Deployed contract address"},name:{type:"string",description:"Token name"},currency:{type:"string",description:"Token currency symbol"},chain:{type:"string",description:"Blockchain chain"},network:{type:"string",description:"Network type"},type:{type:"string",description:"Token type"},decimals:{type:"number",description:"Token decimals"},contractType:{type:"string",enum:["PERMIT","NO_PERMIT","NATIVE"],description:"Contract type"},status:{type:"boolean",description:"Token status"}}}}}}}},400:errors_1.badRequestResponse,401:query_1.unauthorizedResponse,409:(0,errors_1.conflictResponse)("Ecosystem Token"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"create.ecosystem.token"};exports.default=async e=>{var t,s;const{body:r,ctx:o}=e,{name:n,currency:a,chain:i,decimals:c,status:l,precision:p,limits:u,fee:d,icon:y,initialHolder:m,initialSupply:g,marketCap:h}=r;null==o||o.step("Validating token deployment parameters");const k=process.env[`${i}_NETWORK`];if(!k)throw(0,error_1.createError)({statusCode:400,message:`Network not found for chain ${i}`});if(h<0)throw(0,error_1.createError)({statusCode:400,message:"Market cap cannot be negative"});if(g<0)throw(0,error_1.createError)({statusCode:400,message:"Initial supply cannot be negative"});if(h<g)throw(0,error_1.createError)({statusCode:400,message:"Market cap cannot be less than initial supply"});if(0===g)throw(0,error_1.createError)({statusCode:400,message:"Initial supply cannot be zero"});if(!m)throw(0,error_1.createError)({statusCode:400,message:"Initial holder is required"});try{null==o||o.step(`Retrieving master wallet for chain ${i}`);const e=await(0,wallet_1.getMasterWalletByChainFull)(i);if(!e)throw(0,error_1.createError)({statusCode:404,message:`Master wallet for chain ${i} not found`});let r;if("SOL"===i){null==o||o.step("Deploying SPL token on Solana");const t=await(0,safe_imports_1.getSolanaService)();if(!t)throw(0,error_1.createError)({statusCode:503,message:"Solana service not available"});const s=await t.getInstance();r=await s.deploySplToken(e,c,o);null==o||o.step("Queueing initial supply minting");task_1.taskQueue.add(()=>s.mintInitialSupply(e,r,g,c,m,o).then(()=>console.log(`[INFO] Background minting completed for mint ${r}`)).catch(async e=>{await db_1.models.ecosystemToken.destroy({where:{contract:r}});console.error(`[ERROR] Background minting failed for mint ${r}: ${e.message}`)}))}else{null==o||o.step(`Deploying ERC20 token on ${i}`);r=await(0,tokens_1.deployTokenContract)(e,i,n,a,m,c,g,h)}const _=null===(s=null===(t=chains_1.chainConfigs[i])||void 0===t?void 0:t.smartContract)||void 0===s?void 0:s.name;null==o||o.step("Saving token to database");const f=await(0,query_1.storeRecord)({model:"ecosystemToken",data:{contract:r,name:n,currency:a,chain:i,network:k,type:_,decimals:c,status:l,precision:p,limits:JSON.stringify(u),fee:JSON.stringify(d),icon:y,contractType:"PERMIT"},returnResponse:!0});if(f.record&&y)try{null==o||o.step("Updating token icon in cache");await(0,utils_1.updateIconInCache)(a,y)}catch(e){null==o||o.warn(`Failed to update icon in cache: ${e.message}`);console.error(`Failed to update icon in cache for ${a}:`,e)}null==o||o.success(`Token ${a} deployed successfully`);return f}catch(e){null==o||o.fail(e.message);throw(0,error_1.createError)({statusCode:500,message:`Failed to create ecosystem token: ${e.message}`})}};