"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.getMasterWalletBalancesController=exports.metadata=void 0;const error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils"),redis_1=require("@b/utils/redis"),date_fns_1=require("date-fns"),utxo_1=require("@b/api/(ext)/ecosystem/utils/utxo"),provider_1=require("@b/api/(ext)/ecosystem/utils/provider"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),ethers_1=require("ethers");exports.metadata={summary:"Update and get all master wallet balances",description:"Fetches current balances from the blockchain for all master wallets and updates the database. Includes caching mechanism to prevent excessive blockchain queries. Supports UTXO-based chains (BTC, LTC, DOGE, DASH) and account-based chains (ETH, BSC, etc.).",operationId:"updateMasterWalletBalances",tags:["Admin","Ecosystem","Wallet"],responses:{200:{description:"Master wallets updated and retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:{walletId:{type:"string",description:"Wallet identifier"},currency:{type:"string",description:"Currency of the wallet"},balance:{type:"number",description:"Current balance of the wallet"},updatedAt:{type:"string",format:"date-time",description:"Last updated timestamp of the wallet balance"}}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ecosystem.master.wallet"};const getMasterWalletBalancesController=async e=>{const{user:t,ctx:a}=e;null==a||a.step("Updating and fetching master wallet balances");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});try{const e=await(0,utils_1.getAllMasterWallets)(a);await Promise.all(e.map(e=>getWalletBalance(e)));return e}catch(e){throw(0,error_1.createError)({statusCode:500,message:`Failed to fetch master wallets: ${e.message}`})}};exports.getMasterWalletBalancesController=getMasterWalletBalancesController;const getWalletBalance=async e=>{try{const t=`wallet:${e.id}:balance`,a=redis_1.RedisSingleton.getInstance();let r,s=await a.get(t);if(s){"object"!=typeof s&&(s=JSON.parse(s));const e=new Date,t=new Date(s.timestamp);if((0,date_fns_1.differenceInMinutes)(e,t)<5&&0!==parseFloat(s.balance))return}if(["BTC","LTC","DOGE","DASH"].includes(e.chain))r=await(0,utxo_1.fetchUTXOWalletBalance)(e.chain,e.address);else{const t=await(0,provider_1.getProvider)(e.chain),a=await t.getBalance(e.address),s=chains_1.chainConfigs[e.chain].decimals;r=ethers_1.ethers.formatUnits(a.toString(),s)}if(!r||isNaN(parseFloat(r))){console.error(`Invalid formatted balance for ${e.chain} wallet: ${r}`);return}if(0===parseFloat(r))return;await(0,utils_1.updateMasterWalletBalance)(e.id,parseFloat(r));const l={balance:r,timestamp:(new Date).toISOString()};await a.setex(t,300,JSON.stringify(l))}catch(t){console.error(`Failed to fetch ${e.chain} wallet balance: ${t.message}`)}};