"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),faq_validation_1=require("@b/api/(ext)/faq/utils/faq-validation"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Create New FAQ",description:"Creates a new FAQ entry in the system. Validates and sanitizes input data before creation. Automatically determines the order if not specified.",operationId:"createFaq",tags:["Admin","FAQ","Create"],requiresAuth:!0,requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{question:{type:"string",description:"FAQ question"},answer:{type:"string",description:"FAQ answer"},image:{type:"string",description:"Optional image URL"},category:{type:"string",description:"FAQ category"},tags:{type:"array",items:{type:"string"},description:"Tags for the FAQ"},status:{type:"boolean",description:"Active status (default: true)"},order:{type:"number",description:"Display order (auto-assigned if 0)"},pagePath:{type:"string",description:"Page path where FAQ appears"},relatedFaqIds:{type:"array",items:{type:"string",format:"uuid"},description:"Related FAQ IDs"}},required:["question","answer","category","pagePath"]}}}},responses:{200:{description:"FAQ created successfully",content:{"application/json":{schema:{type:"object",description:"Created FAQ object"}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"create.faq",logModule:"ADMIN_FAQ",logTitle:"Create FAQ entry"};exports.default=async e=>{const{user:r,body:t,ctx:a}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const s=(0,faq_validation_1.validateAndSanitizeFAQ)(t,a);if(!s.isValid)throw(0,error_1.createError)({statusCode:400,message:s.errors.join(", ")});const i=s.sanitized;try{null==a||a.step("Determining FAQ order");let e=i.order;if(0===e){const r=await db_1.models.faq.findOne({where:{pagePath:i.pagePath},order:[["order","DESC"]]});e=r?r.order+1:0}null==a||a.step("Creating FAQ entry");const r=await db_1.models.faq.create({...i,order:e,relatedFaqIds:t.relatedFaqIds||[]});null==a||a.success("FAQ entry created successfully");return r}catch(e){console.error("Error creating FAQ:",e);null==a||a.fail("Failed to create FAQ");throw(0,error_1.createError)({statusCode:500,message:e instanceof Error?e.message:"Failed to create FAQ"})}};