"use strict";function getWeekNumber(e){const t=new Date(Date.UTC(e.getFullYear(),e.getMonth(),e.getDate())),s=t.getUTCDay()||7;t.setUTCDate(t.getUTCDate()+4-s);const n=new Date(Date.UTC(t.getUTCFullYear(),0,1));return Math.ceil(((t.getTime()-n.getTime())/864e5+1)/7)}Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),sequelize_1=require("sequelize");exports.metadata={summary:"Retrieves Forex dashboard statistics",description:"Retrieves comprehensive statistics for the Forex admin dashboard including total investments, active users, active plans, total accounts, investment growth chart data, plan distribution, account metrics, signal stats, and recent activity.",operationId:"getForexDashboardStats",tags:["Admin","Forex","Dashboard"],requiresAuth:!0,parameters:[{name:"timeframe",in:"query",description:"Range of data to retrieve",required:!1,schema:{type:"string",enum:["1m","3m","1y"]}}],logModule:"ADMIN_FOREX",logTitle:"Get Forex Dashboard",responses:{200:{description:"Forex dashboard statistics retrieved successfully.",content:{"application/json":{schema:{type:"object",properties:{overview:{type:"object",properties:{totalInvestments:{type:"number"},investmentsGrowth:{type:"number"},activeUsers:{type:"number"},usersGrowth:{type:"number"},activePlans:{type:"number"},plansGrowth:{type:"number"},totalAccounts:{type:"number"},accountsGrowth:{type:"number"},totalProfit:{type:"number"},activeInvestments:{type:"number"},completedInvestments:{type:"number"},winRate:{type:"number"},liveAccounts:{type:"number"},demoAccounts:{type:"number"},totalSignals:{type:"number"},activeSignals:{type:"number"},pendingDeposits:{type:"number"},pendingWithdrawals:{type:"number"}}},chartData:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"}}}},planDistribution:{type:"array",items:{type:"object",properties:{name:{type:"string"},value:{type:"number"}}}},investmentResults:{type:"object",properties:{win:{type:"number"},loss:{type:"number"},draw:{type:"number"}}},recentInvestments:{type:"array",items:{type:"object",properties:{id:{type:"string"},user:{type:"string"},plan:{type:"string"},amount:{type:"number"},profit:{type:"number"},date:{type:"string",format:"date-time"},status:{type:"string"},result:{type:"string"}}}},topPlans:{type:"array",items:{type:"object"}}}}}}},401:{description:"Unauthorized"},500:{description:"Internal Server Error"}},permission:"access.forex"};exports.default=async e=>{var t,s;const{user:n,query:r,ctx:a}=e,{timeframe:i="1y"}=r;if(!(null==n?void 0:n.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const l=new Date;let o,u,d,p;if("1m"===i){o=new Date(l.getFullYear(),l.getMonth(),1);u=new Date(l.getFullYear(),l.getMonth()+1,0);d="%d";const e=u.getDate();p=Array.from({length:e},(e,t)=>(t+1).toString())}else if("3m"===i){o=new Date(l.getFullYear(),l.getMonth()-2,1);u=new Date(l.getFullYear(),l.getMonth()+1,0);d="%Y-%u";const e=[],t=new Date(o);for(;t<=u;){e.push(`${t.getFullYear()}-${getWeekNumber(t)}`);t.setDate(t.getDate()+7)}p=e}else{o=new Date(l.getFullYear(),0,1);u=new Date(l.getFullYear(),11,31);d="%b";p=["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"]}const[m,c,E,v]=await Promise.all([db_1.models.forexInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status != 'REJECTED' THEN amount ELSE 0 END")),0),"totalInvestments"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${new Date(l.getFullYear(),l.getMonth(),1).toISOString()}' AND status != 'REJECTED' THEN amount ELSE 0 END`)),0),"currentInvestments"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${new Date(l.getFullYear(),l.getMonth()-1,1).toISOString()}' AND '${new Date(l.getFullYear(),l.getMonth(),0).toISOString()}' AND status != 'REJECTED' THEN amount ELSE 0 END`)),0),"previousInvestments"]],raw:!0}),db_1.models.forexAccount.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"totalAccounts"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${new Date(l.getFullYear(),l.getMonth(),1).toISOString()}' THEN id ELSE NULL END`)),"currentAccounts"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${new Date(l.getFullYear(),l.getMonth()-1,1).toISOString()}' AND '${new Date(l.getFullYear(),l.getMonth(),0).toISOString()}' THEN id ELSE NULL END`)),"previousAccounts"]],raw:!0}),db_1.models.forexPlan.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"activePlans"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`CASE WHEN createdAt >= '${new Date(l.getFullYear(),l.getMonth(),1).toISOString()}' AND status = true THEN id ELSE NULL END`)),"currentActivePlans"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`CASE WHEN createdAt BETWEEN '${new Date(l.getFullYear(),l.getMonth()-1,1).toISOString()}' AND '${new Date(l.getFullYear(),l.getMonth(),0).toISOString()}' AND status = true THEN id ELSE NULL END`)),"previousActivePlans"]],raw:!0}),db_1.models.forexAccount.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.fn)("DISTINCT",(0,sequelize_1.literal)("userId"))),"activeUsers"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`DISTINCT CASE WHEN createdAt >= '${new Date(l.getFullYear(),l.getMonth(),1).toISOString()}' THEN userId ELSE NULL END`)),"currentActiveUsers"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)(`DISTINCT CASE WHEN createdAt BETWEEN '${new Date(l.getFullYear(),l.getMonth()-1,1).toISOString()}' AND '${new Date(l.getFullYear(),l.getMonth(),0).toISOString()}' THEN userId ELSE NULL END`)),"previousActiveUsers"]],raw:!0})]),N=parseFloat(m.totalInvestments)||0,g=parseFloat(m.currentInvestments)||0,f=parseFloat(m.previousInvestments)||0,_=f>0?Math.round((g-f)/f*100):0,D=parseInt(c.totalAccounts,10)||0,b=parseInt(c.currentAccounts,10)||0,A=parseInt(c.previousAccounts,10)||0,S=A>0?Math.round((b-A)/A*100):0,w=parseInt(E.activePlans,10)||0,I=parseInt(E.currentActivePlans,10)||0,q=parseInt(E.previousActivePlans,10)||0,C=q>0?Math.round((I-q)/q*100):0,T=parseInt(v.activeUsers,10)||0,z=parseInt(v.currentActiveUsers,10)||0,h=parseInt(v.previousActiveUsers,10)||0,y=h>0?Math.round((z-h)/h*100):0,[O,U,M,F,H,L]=await Promise.all([db_1.models.forexInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'ACTIVE' THEN 1 END")),"active"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN 1 END")),"completed"],[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.literal)("CASE WHEN status = 'COMPLETED' THEN profit ELSE 0 END")),0),"totalProfit"]],raw:!0}),db_1.models.forexInvestment.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'WIN' THEN 1 END")),"win"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'LOSS' THEN 1 END")),"loss"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN result = 'DRAW' THEN 1 END")),"draw"]],where:{status:"COMPLETED"},raw:!0}),db_1.models.forexAccount.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN type = 'LIVE' THEN 1 END")),"live"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN type = 'DEMO' THEN 1 END")),"demo"]],raw:!0}),db_1.models.forexSignal.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"total"],[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("CASE WHEN status = true THEN 1 END")),"active"]],raw:!0}),null===(t=db_1.models.forexDeposit)||void 0===t?void 0:t.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"pending"]],where:{status:"PENDING"},raw:!0}).catch(()=>({pending:0})),null===(s=db_1.models.forexWithdraw)||void 0===s?void 0:s.findOne({attributes:[[(0,sequelize_1.fn)("COUNT",(0,sequelize_1.literal)("id")),"pending"]],where:{status:"PENDING"},raw:!0}).catch(()=>({pending:0}))]),x=parseInt((null==O?void 0:O.active)||"0",10),P=parseInt((null==O?void 0:O.completed)||"0",10),W=parseFloat((null==O?void 0:O.totalProfit)||"0"),Y=parseInt((null==U?void 0:U.win)||"0",10),$=parseInt((null==U?void 0:U.loss)||"0",10),R=parseInt((null==U?void 0:U.draw)||"0",10),G=Y+$+R,j={totalInvestments:N,investmentsGrowth:_,activeUsers:T,usersGrowth:y,activePlans:w,plansGrowth:C,totalAccounts:D,accountsGrowth:S,totalProfit:W,activeInvestments:x,completedInvestments:P,winRate:G>0?Math.round(Y/G*100):0,liveAccounts:parseInt((null==M?void 0:M.live)||"0",10),demoAccounts:parseInt((null==M?void 0:M.demo)||"0",10),totalSignals:parseInt((null==F?void 0:F.total)||"0",10),activeSignals:parseInt((null==F?void 0:F.active)||"0",10),pendingDeposits:parseInt((null==H?void 0:H.pending)||"0",10),pendingWithdrawals:parseInt((null==L?void 0:L.pending)||"0",10)},J={win:Y,loss:$,draw:R},k=await db_1.models.forexInvestment.findAll({attributes:[[(0,sequelize_1.fn)("DATE_FORMAT",(0,sequelize_1.col)("createdAt"),d),"period"],[(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("amount")),"totalInvested"]],where:{status:{[sequelize_1.Op.ne]:"REJECTED"},createdAt:{[sequelize_1.Op.between]:[o,u]}},group:["period"],raw:!0}),B={};k.forEach(e=>{B[e.period]=parseFloat(e.totalInvested)||0});const V=p.map(e=>({name:e,value:B[e]||0})),X=(await db_1.models.forexPlan.findAll({attributes:["name",[(0,sequelize_1.fn)("COALESCE",(0,sequelize_1.fn)("SUM",(0,sequelize_1.col)("investments.amount")),0),"totalInvested"]],include:[{model:db_1.models.forexInvestment,as:"investments",attributes:[],where:{status:{[sequelize_1.Op.ne]:"REJECTED"}},required:!1}],group:["forexPlan.id"],raw:!0})).map(e=>({name:e.name,value:parseFloat(e.totalInvested)||0})),K=(await db_1.models.forexInvestment.findAll({where:{},include:[{model:db_1.models.user,as:"user",attributes:["firstName","lastName"]},{model:db_1.models.forexPlan,as:"plan",attributes:["name"]}],order:[["createdAt","DESC"]],limit:5,raw:!0,nest:!0})).map(e=>{var t;return{id:e.id,user:e.user?`${e.user.firstName} ${e.user.lastName}`:"Unknown",userId:e.userId,plan:(null===(t=e.plan)||void 0===t?void 0:t.name)||"Unknown",amount:e.amount,profit:e.profit||0,date:e.createdAt,status:e.status,result:e.result}});return{overview:j,chartData:V,planDistribution:X,investmentResults:J,recentInvestments:K,topPlans:await db_1.models.forexPlan.findAll({attributes:["id","name","title","image","minAmount","maxAmount","minProfit","maxProfit","status","trending"],where:{status:!0},order:[["trending","DESC"]],limit:5,raw:!0})}};