"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Lists all Forex investments",description:"Retrieves a paginated list of all Forex investments with filtering and sorting options. Includes user, plan, and duration details for each investment.",operationId:"listForexInvestments",tags:["Admin","Forex","Investment"],parameters:constants_1.crudParameters,logModule:"ADMIN_FOREX",logTitle:"Get Forex Investments",responses:{200:{description:"List of Forex Investments with pagination information",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object",properties:utils_1.forexInvestmentSchema}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Investments"),500:query_1.serverErrorResponse},requiresAuth:!0,permission:"view.forex.investment",demoMask:["items.user.email"]};exports.default=async e=>{var t;const{query:s,ctx:r}=e;null==r||r.step("Fetching forex investments");const i=await(0,query_1.getFiltered)({model:db_1.models.forexInvestment,query:s,sortField:s.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.forexPlan,as:"plan",attributes:["id","title"]},{model:db_1.models.forexDuration,as:"duration",attributes:["id","duration","timeframe"]}],numericFields:["amount","profit"]});null==r||r.success(`Retrieved ${(null===(t=i.items)||void 0===t?void 0:t.length)||0} forex investments`);return i};