"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk updates the status of futures markets",operationId:"bulkUpdateFuturesMarketStatus",tags:["Admin","Futures","Market"],description:"Updates the active/inactive status of multiple futures markets simultaneously. Active markets are available for trading, while inactive markets are hidden from users.",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of futures market IDs to update",items:{type:"string"}},status:{type:"boolean",description:"New status to apply to the futures markets (true for active, false for inactive)"}},required:["ids","status"]}}}},responses:{200:{description:"Futures market status updated successfully",content:{"application/json":{schema:{type:"object",properties:{message:{type:"string",description:"Success message"}}}}}},400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Futures Markets"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"edit.futures.market",logModule:"ADMIN_FUTURES",logTitle:"Bulk update futures market status"};exports.default=async e=>{const{body:t,ctx:s}=e,{ids:r,status:a}=t;try{null==s||s.step(`Updating ${r.length} markets to ${a?"active":"inactive"}`);const e=await(0,query_1.updateStatus)("futuresMarket",r,a);null==s||s.success(`Successfully updated status for ${r.length} futures markets`);return e}catch(e){null==s||s.fail(`Failed to bulk update market status: ${e.message}`);throw e}};