"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Get ICO Platform Settings",description:"Retrieves ICO platform-wide settings including investment limits, fees, KYC requirements, maintenance mode, and announcement configuration.",operationId:"getIcoPlatformSettings",tags:["Admin","ICO","Settings"],requiresAuth:!0,responses:{200:{description:"Platform settings retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{minInvestmentAmount:{type:"number",description:"Minimum platform investment amount"},maxInvestmentAmount:{type:"number",description:"Maximum platform investment amount"},platformFeePercentage:{type:"number",description:"Platform fee percentage"},kycRequired:{type:"boolean",description:"Whether KYC is required"},maintenanceMode:{type:"boolean",description:"Whether platform is in maintenance mode"},allowPublicOfferings:{type:"boolean",description:"Whether public offerings are allowed"},announcementMessage:{type:"string",description:"Platform announcement message"},announcementActive:{type:"boolean",description:"Whether announcement is active"}}}}}},401:errors_1.unauthorizedResponse,500:errors_1.serverErrorResponse},permission:"view.ico.settings",logModule:"ADMIN_ICO",logTitle:"Get platform settings"};exports.default=async e=>{const{user:t,ctx:n}=e;null==n||n.step("Validating user permissions");if(!(null==t?void 0:t.id)){null==n||n.fail("Unauthorized access");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: Admin privileges required."})}null==n||n.step("Fetching platform settings");const r=(await db_1.models.settings.findAll({where:{key:["icoPlatformMinInvestmentAmount","icoPlatformMaxInvestmentAmount","icoPlatformFeePercentage","icoPlatformKycRequired","icoPlatformMaintenanceMode","icoPlatformAllowPublicOfferings","icoPlatformAnnouncementMessage","icoPlatformAnnouncementActive"]}})).reduce((e,t)=>{e[t.key]=t.value;return e},{});null==n||n.success("Platform settings retrieved successfully");return{minInvestmentAmount:parseFloat(r.icoPlatformMinInvestmentAmount||"0"),maxInvestmentAmount:parseFloat(r.icoPlatformMaxInvestmentAmount||"0"),platformFeePercentage:parseFloat(r.icoPlatformFeePercentage||"0"),kycRequired:"true"===r.icoPlatformKycRequired,maintenanceMode:"true"===r.icoPlatformMaintenanceMode,allowPublicOfferings:"true"===r.icoPlatformAllowPublicOfferings,announcementMessage:r.icoPlatformAnnouncementMessage||"",announcementActive:"true"===r.icoPlatformAnnouncementActive}};