"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk delete Mailwizard campaigns",description:"Permanently deletes multiple Mailwizard campaigns by their IDs. This operation cannot be undone and will remove all campaign data including targets and execution history.",operationId:"bulkDeleteMailwizardCampaigns",tags:["Admin","Mailwizard","Campaigns"],parameters:(0,query_1.commonBulkDeleteParams)("Mailwizard Campaigns"),requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",items:{type:"string"},description:"Array of Mailwizard campaign IDs to delete"}},required:["ids"]}}}},responses:(0,errors_1.bulkDeleteResponses)("Mailwizard Campaign"),requiresAuth:!0,permission:"delete.mailwizard.campaign",logModule:"ADMIN_MAIL",logTitle:"Bulk delete campaigns"};exports.default=async e=>{const{body:a,query:i,ctx:r}=e,{ids:t}=a;null==r||r.step(`Deleting ${t.length} campaigns`);const s=await(0,query_1.handleBulkDelete)({model:"mailwizardCampaign",ids:t,query:i});null==r||r.success(`${t.length} campaigns deleted successfully`);return s};