"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"Import a Mailwizard template",operationId:"importMailwizardTemplate",tags:["Admin","Mailwizard","Templates"],description:"Imports a new Mailwizard email template with content and design configuration. This endpoint is used to import pre-designed templates with both HTML content and visual design data.",requestBody:{required:!0,content:{"application/json":{schema:utils_1.mailwizardTemplateCreateSchema}}},responses:{200:(0,errors_1.singleItemResponse)({type:"object",properties:utils_1.mailwizardTemplateSchema},"Mailwizard template imported successfully"),400:errors_1.badRequestResponse,401:errors_1.unauthorizedResponse,409:(0,errors_1.conflictResponse)("Mailwizard Template"),500:errors_1.serverErrorResponse},requiresAuth:!0,permission:"create.mailwizard.template",logModule:"ADMIN_MAIL",logTitle:"Import template"};exports.default=async e=>{const{body:t,ctx:r}=e,{name:s,content:a,design:i}=t;null==r||r.step("Importing template");const o=await(0,query_1.storeRecord)({model:"mailwizardTemplate",data:{name:s,content:a,design:i}});null==r||r.success("Template imported successfully");return o};