"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),constants_1=require("@b/utils/constants"),query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors"),utils_1=require("./utils");exports.metadata={summary:"List Mailwizard templates",operationId:"listMailwizardTemplates",tags:["Admin","Mailwizard","Templates"],description:"Retrieves a paginated list of all Mailwizard email templates with optional filtering and sorting. Templates can be filtered by name, creation date, and other criteria.",parameters:constants_1.crudParameters,responses:{200:(0,errors_1.paginatedResponse)({type:"object",properties:utils_1.mailwizardTemplateSchema},"Mailwizard templates retrieved successfully"),401:errors_1.unauthorizedResponse,404:(0,errors_1.notFoundResponse)("Mailwizard Template"),500:errors_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_MAIL",logTitle:"Get Mail Templates",permission:"view.mailwizard.template"};exports.default=async e=>{const{query:t,ctx:r}=e;null==r||r.step("Fetch mail templates with filters");const s=await(0,query_1.getFiltered)({model:db_1.models.mailwizardTemplate,query:t,sortField:t.sortField||"createdAt"});null==r||r.success("Get Mail Templates retrieved successfully");return s};