"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),errors_1=require("@b/utils/schema/errors");exports.metadata={summary:"Bulk update template status",operationId:"bulkUpdateMailwizardTemplateStatus",tags:["Admin","Mailwizard","Templates"],description:"Updates the status of multiple Mailwizard templates simultaneously. Valid statuses: ACTIVE, INACTIVE, ARCHIVED. This allows for efficient batch status management of templates.",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{ids:{type:"array",description:"Array of Mailwizard Template IDs to update",items:{type:"string"}},status:{type:"string",enum:["ACTIVE","INACTIVE","ARCHIVED"],description:"New status to apply to the Mailwizard Templates"}},required:["ids","status"]}}}},responses:(0,errors_1.statusUpdateResponses)("Mailwizard Template"),requiresAuth:!0,permission:"edit.mailwizard.template",logModule:"ADMIN_MAIL",logTitle:"Bulk update template status"};exports.default=async t=>{const{body:e,ctx:s}=t,{ids:a,status:r}=e;null==s||s.step(`Updating status of ${a.length} templates to ${r}`);const i=await(0,query_1.updateStatus)("mailwizardTemplate",a,r);null==s||s.success(`${a.length} templates status updated successfully`);return i};