"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),query_1=require("@b/utils/query"),constants_1=require("@b/utils/constants"),error_1=require("@b/utils/error");exports.metadata={summary:"List all P2P offers",operationId:"listAdminP2POffers",tags:["Admin","P2P","Offer"],parameters:constants_1.crudParameters,responses:{200:{description:"Retrieves a paginated list of all P2P offers with detailed information including user details, payment methods, and offer status. Supports filtering, sorting, and pagination.",content:{"application/json":{schema:{type:"object",properties:{items:{type:"array",items:{type:"object"}},pagination:constants_1.paginationSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("p2p Offers"),500:query_1.serverErrorResponse},requiresAuth:!0,logModule:"ADMIN_P2P",logTitle:"Get P2P Offers",permission:"view.p2p.offer",demoMask:["items.user.email"]};exports.default=async e=>{const{query:t,user:r,ctx:s}=e;null==s||s.step("Fetching data");if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const i=await(0,query_1.getFiltered)({model:db_1.models.p2pOffer,query:t,sortField:t.sortField||"createdAt",includeModels:[{model:db_1.models.user,as:"user",attributes:["id","firstName","lastName","email","avatar"]},{model:db_1.models.p2pPaymentMethod,as:"paymentMethods",attributes:["id","name","icon"],through:{attributes:[]}}]});i.items&&Array.isArray(i.items)&&(i.items=i.items.map(e=>{const t=e.get?e.get({plain:!0}):e;!t.priceCurrency&&t.priceConfig&&(t.priceCurrency=t.priceConfig.currency||"USD");return t}));null==s||s.success("P2P offers retrieved successfully");return i};