"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const utils_1=require("@b/api/(ext)/affiliate/utils"),db_1=require("@b/db"),error_1=require("@b/utils/error");exports.metadata={summary:"Fetch MLM node details by UUID",description:"Retrieves information about a specific MLM node using its UUID.",operationId:"getNodeById",tags:["MLM","Referrals"],responses:{200:{description:"Node details retrieved successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"number",description:"User ID"},firstName:{type:"string",description:"First name"},lastName:{type:"string",description:"Last name"},referrals:{type:"array",items:{type:"object",properties:{id:{type:"number",description:"Referral ID"}}}}}}}}},404:{description:"Node not found"},500:{description:"Internal server error"}},requiresAuth:!0,logModule:"AFFILIATE",logTitle:"Get affiliate node details"};exports.default=async e=>{const{user:r,ctx:t}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});null==t||t.step("Fetching user details with referral associations");const s=await db_1.models.user.findByPk(r.id,{include:[{model:db_1.models.mlmReferral,as:"referrerReferrals",include:[{model:db_1.models.user,as:"referred",attributes:["id","firstName","lastName","avatar","createdAt","status"]}]},{model:db_1.models.mlmReferral,as:"referredReferrals",include:[{model:db_1.models.user,as:"referrer",attributes:["id","firstName","lastName","avatar","createdAt","status"]}]},{model:db_1.models.mlmReferralReward,as:"referralRewards",attributes:["id"]}]});if(!s)throw(0,error_1.createError)({statusCode:404,message:"User not found"});null==t||t.step("Loading MLM system settings from cache");const{mlmSystem:a,mlmSettings:i}=await(0,utils_1.getMlmSystemAndSettings)();null==t||t.step(`Building ${a||"DIRECT"} referral tree structure`);let l;switch(a){case"DIRECT":default:l=await(0,utils_1.listDirectReferrals)(s,t);break;case"BINARY":l=await(0,utils_1.listBinaryReferrals)(s,i,t);break;case"UNILEVEL":l=await(0,utils_1.listUnilevelReferrals)(s,i,t)}null==t||t.success(`Retrieved ${a||"DIRECT"} node details for user`);return l};