"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),utils_1=require("@b/api/(ext)/copy-trading/utils");exports.metadata={summary:"Add a market for leader to trade",description:"Declares a new market that the leader will trade on. Followers will need to provide liquidity for this market.",operationId:"addLeaderMarket",tags:["Copy Trading","Leader"],requiresAuth:!0,logModule:"COPY",logTitle:"Add leader market",requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{symbol:{type:"string",description:"Market symbol (e.g., BTC/USDT)"},minBase:{type:"number",description:"Minimum base currency allocation amount"},minQuote:{type:"number",description:"Minimum quote currency allocation amount"}},required:["symbol"]}}}},responses:{200:{description:"Market added successfully",content:{"application/json":{schema:{type:"object",properties:{id:{type:"string"},symbol:{type:"string"},baseCurrency:{type:"string"},quoteCurrency:{type:"string"},minBase:{type:"number"},minQuote:{type:"number"},isActive:{type:"boolean"}}}}}},400:{description:"Bad Request"},401:{description:"Unauthorized"},404:{description:"Leader or Market not found"}}};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{symbol:i,minBase:s,minQuote:o}=r;if(!i||"string"!=typeof i)throw(0,error_1.createError)({statusCode:400,message:"Symbol is required"});null==a||a.step("Finding leader profile");const n=await db_1.models.copyTradingLeader.findOne({where:{userId:t.id,status:"ACTIVE"}});if(!n)throw(0,error_1.createError)({statusCode:404,message:"Active leader profile not found"});null==a||a.step("Parsing symbol");const d=i.split("/");if(2!==d.length)throw(0,error_1.createError)({statusCode:400,message:"Invalid symbol format. Use BASE/QUOTE (e.g., BTC/USDT)"});const[u,l]=d;null==a||a.step("Validating market exists");if(!await db_1.models.ecosystemMarket.findOne({where:{currency:u,pair:l,status:!0}}))throw(0,error_1.createError)({statusCode:400,message:`Market ${i} not found or inactive`});null==a||a.step("Checking existing market");const c=await db_1.models.copyTradingLeaderMarket.findOne({where:{leaderId:n.id,symbol:i}});if(c){if(c.isActive)throw(0,error_1.createError)({statusCode:400,message:"Market already added"});null==a||a.step("Reactivating market");await c.update({isActive:!0,minBase:null!=s?s:c.minBase,minQuote:null!=o?o:c.minQuote});await(0,utils_1.createAuditLog)({entityType:"LEADER",entityId:n.id,action:"UPDATE",oldValue:{symbol:i,isActive:!1},newValue:{symbol:i,isActive:!0,minBase:s,minQuote:o},userId:t.id,reason:"Market reactivated"});null==a||a.success("Market reactivated");return c}null==a||a.step("Creating market");const m=await db_1.models.copyTradingLeaderMarket.create({leaderId:n.id,symbol:i,baseCurrency:u,quoteCurrency:l,minBase:s||0,minQuote:o||0,isActive:!0});await(0,utils_1.createAuditLog)({entityType:"LEADER",entityId:n.id,action:"UPDATE",newValue:{symbol:i,baseCurrency:u,quoteCurrency:l},userId:t.id,reason:"Market added"});null==a||a.success("Market added");return m};