"use strict";async function checkDailyLimits(e){try{const t=await db_1.models.copyTradingFollower.findByPk(e);if(!t)return{canTrade:!1,reason:"Follower not found"};const o=t;if("ACTIVE"!==o.status)return{canTrade:!1,reason:"Subscription is not active"};const r=await getDailyStats(e),a=(await(0,index_1.getCopyTradingSettings)()).maxDailyLossDefault||50,i=o.maxDailyLoss;return r.tradesCount>=a?{canTrade:!1,reason:"Daily trade limit reached",currentTrades:r.tradesCount,maxTrades:a}:i&&i>0&&r.totalLoss>=i?{canTrade:!1,reason:"Daily loss limit reached",currentLoss:r.totalLoss,maxLoss:i}:{canTrade:!0}}catch(e){console_1.logger.error("COPY_TRADING","Failed to check daily limits",e);return{canTrade:!0}}}async function getDailyStats(e){const t=new Date;t.setHours(0,0,0,0);try{const o=await db_1.models.copyTradingTrade.findAll({where:{followerId:e,createdAt:{[sequelize_1.Op.gte]:t}},attributes:["profit","cost","status","symbol","profitCurrency"]}),r=o.length;let a=0,i=0,s=0;const n={},c={};for(const e of o){const t=e.profit||0,o=e.cost||0;let r=e.profitCurrency;!r&&e.symbol&&(r=(0,currency_1.getQuoteCurrency)(e.symbol));r||(r="USDT");try{const e=await(0,currency_1.convertToUSDT)(t,r),l=await(0,currency_1.convertToUSDT)(o,r);if(e>0){a+=e;n[r]=(n[r]||0)+t}else if(e<0){i+=Math.abs(e);c[r]=(c[r]||0)+Math.abs(t)}s+=l}catch(e){console_1.logger.warn("COPY_TRADING",`Currency conversion failed for ${r}, using raw value`,e);if(t>0){a+=t;n[r]=(n[r]||0)+t}else{i+=Math.abs(t);c[r]=(c[r]||0)+Math.abs(t)}s+=o}}return{tradesCount:r,totalProfit:a,totalLoss:i,netPnL:a-i,totalVolume:s,profitByCurrency:n,lossByCurrency:c}}catch(e){console_1.logger.error("COPY_TRADING","Failed to get daily stats",e);return{tradesCount:0,totalProfit:0,totalLoss:0,netPnL:0,totalVolume:0,profitByCurrency:{},lossByCurrency:{}}}}async function recordTrade(e){const t=(new Date).toISOString().split("T")[0],o=`${e}:${t}`,r=dailyLimitsCache.get(o)||{trades:0,loss:0,date:t};r.trades+=1;dailyLimitsCache.set(o,r)}async function recordLoss(e,t,o="USDT"){if(t<=0)return;const r=(new Date).toISOString().split("T")[0],a=`${e}:${r}`;let i;try{i=await(0,currency_1.convertToUSDT)(t,o)}catch(e){console_1.logger.warn("COPY_TRADING",`Failed to convert loss from ${o} to USDT, using raw value`,e);i=t}const s=dailyLimitsCache.get(a)||{trades:0,loss:0,date:r};s.loss+=i;dailyLimitsCache.set(a,s);const n=await db_1.models.copyTradingFollower.findByPk(e);if(n){const t=n.maxDailyLoss;t&&s.loss>=t&&await pauseFollowerDueToDailyLimit(e,s.loss,t)}}async function pauseFollowerDueToDailyLimit(e,t,o){try{await db_1.models.copyTradingFollower.update({status:"PAUSED"},{where:{id:e}});const r=await db_1.models.copyTradingFollower.findByPk(e,{include:[{model:db_1.models.user,as:"user"}]});if(r){const a=r,i=(new Date).toISOString().split("T")[0];await notification_1.notificationService.send({userId:a.userId,type:"SYSTEM",channels:["IN_APP"],idempotencyKey:`copy_trading_paused_${e}_${i}`,data:{title:"Copy Trading Paused",message:`Your copy trading subscription has been paused because your daily loss limit (${(0,currency_1.formatCurrencyAmount)(o,"USDT")}) was reached. Current loss: ${(0,currency_1.formatCurrencyAmount)(t,"USDT")}. You can resume trading tomorrow.`,link:"/copy-trading/subscription"},priority:"HIGH"});await(0,index_1.createAuditLog)({entityType:"copyTradingFollower",entityId:e,action:"DAILY_LOSS_LIMIT_REACHED",userId:a.userId,metadata:{currentLoss:t,maxLoss:o,currency:"USDT"}})}}catch(e){console_1.logger.error("COPY_TRADING","Failed to pause follower due to daily limit",e)}}async function resetDailyLimits(){let e=0,t=0;try{dailyLimitsCache.clear();e++;const o=await db_1.models.copyTradingFollower.findAll({where:{status:"PAUSED"},include:[{model:db_1.models.copyTradingAuditLog,as:"auditLogs",where:{action:"DAILY_LOSS_LIMIT_REACHED",createdAt:{[sequelize_1.Op.gte]:new Date(Date.now()-864e5)}},required:!0,limit:1}]});for(const e of o){await e.update({status:"ACTIVE"});t++;await notification_1.notificationService.send({userId:e.userId,type:"SYSTEM",channels:["IN_APP"],idempotencyKey:`copy_trading_resumed_${e.id}_${(new Date).toISOString().split("T")[0]}`,data:{title:"Copy Trading Resumed",message:"Your copy trading subscription has been automatically reactivated for the new trading day.",link:"/copy-trading/subscription"},priority:"NORMAL"});await(0,index_1.createAuditLog)({entityType:"copyTradingFollower",entityId:e.id,action:"DAILY_LIMITS_RESET",userId:e.userId})}console_1.logger.info("COPY_TRADING",`Daily limits reset complete: ${e} caches cleared, ${t} followers reactivated`);return{reset:e,reactivated:t}}catch(o){console_1.logger.error("COPY_TRADING","Failed to reset daily limits",o);return{reset:e,reactivated:t}}}async function updateFollowerLimits(e,t){try{const o=await db_1.models.copyTradingFollower.findByPk(e);if(!o)return{success:!1,error:"Follower not found"};await o.update(t);await(0,index_1.createAuditLog)({entityType:"copyTradingFollower",entityId:e,action:"LIMITS_UPDATED",userId:o.userId,newValue:t});return{success:!0}}catch(e){console_1.logger.error("COPY_TRADING","Failed to update follower limits",e);return{success:!1,error:e.message}}}async function getFollowerLimitStatus(e){const t=await db_1.models.copyTradingFollower.findByPk(e);if(!t)return{limits:{maxDailyLoss:null,maxPositionSize:null,stopLossPercent:null,takeProfitPercent:null},currentUsage:{tradesCount:0,totalProfit:0,totalLoss:0,netPnL:0,totalVolume:0,profitByCurrency:{},lossByCurrency:{}},canTrade:!1,reason:"Follower not found",currency:"USDT"};const o=t,r=await getDailyStats(e),a=await checkDailyLimits(e);return{limits:{maxDailyLoss:o.maxDailyLoss,maxPositionSize:o.maxPositionSize,stopLossPercent:o.stopLossPercent,takeProfitPercent:o.takeProfitPercent},currentUsage:r,canTrade:a.canTrade,reason:a.reason,currency:"USDT"}}async function checkAutoActions(){let e=0,t=0;try{const o=await db_1.models.copyTradingFollower.findAll({where:{status:"ACTIVE",maxDailyLoss:{[sequelize_1.Op.gt]:0}}});for(const r of o){e++;const o=await getDailyStats(r.id);if(o.totalLoss>=r.maxDailyLoss){await pauseFollowerDueToDailyLimit(r.id,o.totalLoss,r.maxDailyLoss);t++}}return{checked:e,paused:t}}catch(o){console_1.logger.error("COPY_TRADING","Failed to check auto actions",o);return{checked:e,paused:t}}}Object.defineProperty(exports,"__esModule",{value:!0});exports.checkDailyLimits=checkDailyLimits;exports.getDailyStats=getDailyStats;exports.recordTrade=recordTrade;exports.recordLoss=recordLoss;exports.resetDailyLimits=resetDailyLimits;exports.updateFollowerLimits=updateFollowerLimits;exports.getFollowerLimitStatus=getFollowerLimitStatus;exports.checkAutoActions=checkAutoActions;const db_1=require("@b/db"),sequelize_1=require("sequelize"),console_1=require("@b/utils/console"),index_1=require("./index"),currency_1=require("./currency"),notification_1=require("@b/services/notification"),dailyLimitsCache=new Map;