"use strict";async function leaderApplyRateLimiter(e){var i,a,t;const{user:o}=e,r=(await(0,index_1.getCopyTradingSettings)()).leaderApplicationRateLimit||10,n="copytrading:leader:apply";let s;if(null==o?void 0:o.id)s=`${n}:user:${o.id}`;else{s=`${n}:ip:${(null===(i=e.req)||void 0===i?void 0:i.ip)||(null===(t=null===(a=e.req)||void 0===a?void 0:a.connection)||void 0===t?void 0:t.remoteAddress)||"unknown"}`}const l=redis_1.RedisSingleton.getInstance(),d=await l.get(s);if(null!==d&&parseInt(d,10)>=r)throw(0,error_1.createError)({statusCode:429,message:"Too many leader applications. Please wait 24 hours before trying again."});null===d?await l.set(s,"1","EX",86400):await l.incr(s)}function isValidUUID(e){return"string"==typeof e&&/^[0-9a-f]{8}-[0-9a-f]{4}-[1-5][0-9a-f]{3}-[89ab][0-9a-f]{3}-[0-9a-f]{12}$/i.test(e)}function sanitizeString(e,i=1e3){return"string"!=typeof e?"":e.trim().slice(0,i).replace(/[<>]/g,"").replace(/'/g,"''").replace(/\\/g,"\\\\")}function validateNumber(e,i={}){const{min:a,max:t,allowZero:o=!0,allowNegative:r=!1}=i,n=parseFloat(e);return isNaN(n)?{valid:!1,value:0,error:"Invalid number"}:o||0!==n?!r&&n<0?{valid:!1,value:0,error:"Negative values are not allowed"}:void 0!==a&&n<a?{valid:!1,value:n,error:`Value must be at least ${a}`}:void 0!==t&&n>t?{valid:!1,value:n,error:`Value must not exceed ${t}`}:{valid:!0,value:n}:{valid:!1,value:0,error:"Zero is not allowed"}}function validateLeaderApplication(e){const i=[],a={};if(e.displayName&&"string"==typeof e.displayName){const t=sanitizeString(e.displayName,100);t.length<2?i.push("Display name must be at least 2 characters"):t.length>100?i.push("Display name must not exceed 100 characters"):/^[a-zA-Z0-9\s\-_]+$/.test(t)?a.displayName=t:i.push("Display name can only contain letters, numbers, spaces, hyphens, and underscores")}else i.push("Display name is required");e.bio&&(a.bio=sanitizeString(e.bio,1e3));const t=["SCALPING","DAY_TRADING","SWING","POSITION"];e.tradingStyle&&t.includes(e.tradingStyle)?a.tradingStyle=e.tradingStyle:i.push(`Trading style must be one of: ${t.join(", ")}`);const o=["LOW","MEDIUM","HIGH"];e.riskLevel&&o.includes(e.riskLevel)?a.riskLevel=e.riskLevel:i.push(`Risk level must be one of: ${o.join(", ")}`);if(void 0!==e.profitSharePercent){const t=validateNumber(e.profitSharePercent,{min:0,max:50});t.valid?a.profitSharePercent=t.value:i.push(`Profit share: ${t.error}`)}if(void 0!==e.minFollowAmount){const t=validateNumber(e.minFollowAmount,{min:0,max:1e6});t.valid?a.minFollowAmount=t.value:i.push(`Minimum follow amount: ${t.error}`)}e.applicationNote&&(a.applicationNote=sanitizeString(e.applicationNote,2e3));return{valid:0===i.length,errors:i,sanitized:a}}function validateFollowRequest(e){const i=[],a={};e.leaderId?isValidUUID(e.leaderId)?a.leaderId=e.leaderId:i.push("Invalid leader ID format"):i.push("Leader ID is required");const t=["PROPORTIONAL","FIXED_AMOUNT","FIXED_RATIO"];e.copyMode&&!t.includes(e.copyMode)?i.push(`Copy mode must be one of: ${t.join(", ")}`):a.copyMode=e.copyMode||"PROPORTIONAL";if("FIXED_AMOUNT"===a.copyMode)if(e.fixedAmount){const t=validateNumber(e.fixedAmount,{min:.01,max:1e5,allowZero:!1});t.valid?a.fixedAmount=t.value:i.push(`Fixed amount: ${t.error}`)}else i.push("Fixed amount is required for FIXED_AMOUNT mode");if("FIXED_RATIO"===a.copyMode)if(e.fixedRatio){const t=validateNumber(e.fixedRatio,{min:.01,max:10,allowZero:!1});t.valid?a.fixedRatio=t.value:i.push(`Fixed ratio: ${t.error}`)}else i.push("Fixed ratio is required for FIXED_RATIO mode");if(void 0!==e.maxDailyLoss){const t=validateNumber(e.maxDailyLoss,{min:0,max:100});t.valid?a.maxDailyLoss=t.value:i.push(`Max daily loss: ${t.error}`)}if(void 0!==e.maxPositionSize){const t=validateNumber(e.maxPositionSize,{min:0,max:100});t.valid?a.maxPositionSize=t.value:i.push(`Max position size: ${t.error}`)}if(void 0!==e.stopLossPercent){const t=validateNumber(e.stopLossPercent,{min:0,max:100});t.valid?a.stopLossPercent=t.value:i.push(`Stop loss: ${t.error}`)}if(void 0!==e.takeProfitPercent){const t=validateNumber(e.takeProfitPercent,{min:0,max:1e3});t.valid?a.takeProfitPercent=t.value:i.push(`Take profit: ${t.error}`)}return{valid:0===i.length,errors:i,sanitized:a}}function validateFundOperation(e){const i=[],a={};if(e.amount){const t=validateNumber(e.amount,{min:.01,max:1e7,allowZero:!1});t.valid?a.amount=t.value:i.push(`Amount: ${t.error}`)}else i.push("Amount is required");return{valid:0===i.length,errors:i,sanitized:a}}function validateSubscriptionUpdate(e){const i=[],a={};if(e.copyMode){const t=["PROPORTIONAL","FIXED_AMOUNT","FIXED_RATIO"];t.includes(e.copyMode)?a.copyMode=e.copyMode:i.push(`Copy mode must be one of: ${t.join(", ")}`)}if(void 0!==e.fixedAmount){const t=validateNumber(e.fixedAmount,{min:.01,max:1e5});t.valid?a.fixedAmount=t.value:i.push(`Fixed amount: ${t.error}`)}if(void 0!==e.fixedRatio){const t=validateNumber(e.fixedRatio,{min:.01,max:10});t.valid?a.fixedRatio=t.value:i.push(`Fixed ratio: ${t.error}`)}if(void 0!==e.maxDailyLoss){const t=validateNumber(e.maxDailyLoss,{min:0,max:100});t.valid?a.maxDailyLoss=t.value:i.push(`Max daily loss: ${t.error}`)}if(void 0!==e.maxPositionSize){const t=validateNumber(e.maxPositionSize,{min:0,max:100});t.valid?a.maxPositionSize=t.value:i.push(`Max position size: ${t.error}`)}if(void 0!==e.stopLossPercent){const t=validateNumber(e.stopLossPercent,{min:0,max:100});t.valid?a.stopLossPercent=t.value:i.push(`Stop loss: ${t.error}`)}if(void 0!==e.takeProfitPercent){const t=validateNumber(e.takeProfitPercent,{min:0,max:1e3});t.valid?a.takeProfitPercent=t.value:i.push(`Take profit: ${t.error}`)}return{valid:0===i.length,errors:i,sanitized:a}}function validateLeaderUpdate(e){const i=[],a={};if(void 0!==e.displayName)if("string"!=typeof e.displayName)i.push("Display name must be a string");else{const t=sanitizeString(e.displayName,100);t.length<2?i.push("Display name must be at least 2 characters"):/^[a-zA-Z0-9\s\-_]+$/.test(t)?a.displayName=t:i.push("Display name can only contain letters, numbers, spaces, hyphens, and underscores")}void 0!==e.bio&&(a.bio=sanitizeString(e.bio,1e3));if(void 0!==e.tradingStyle){const t=["SCALPING","DAY_TRADING","SWING","POSITION"];t.includes(e.tradingStyle)?a.tradingStyle=e.tradingStyle:i.push(`Trading style must be one of: ${t.join(", ")}`)}if(void 0!==e.riskLevel){const t=["LOW","MEDIUM","HIGH"];t.includes(e.riskLevel)?a.riskLevel=e.riskLevel:i.push(`Risk level must be one of: ${t.join(", ")}`)}if(void 0!==e.profitSharePercent){const t=validateNumber(e.profitSharePercent,{min:0,max:50});t.valid?a.profitSharePercent=t.value:i.push(`Profit share: ${t.error}`)}if(void 0!==e.minFollowAmount){const t=validateNumber(e.minFollowAmount,{min:0,max:1e6});t.valid?a.minFollowAmount=t.value:i.push(`Minimum follow amount: ${t.error}`)}if(void 0!==e.maxFollowers){const t=validateNumber(e.maxFollowers,{min:1,max:1e4});t.valid?a.maxFollowers=t.value:i.push(`Max followers: ${t.error}`)}void 0!==e.isPublic&&(a.isPublic=Boolean(e.isPublic));return{valid:0===i.length,errors:i,sanitized:a}}function validatePagination(e){let i=parseInt(e.page||"1",10),a=parseInt(e.limit||"20",10);i=Math.max(1,Math.min(i,1e3));a=Math.max(1,Math.min(a,100));return{page:i,limit:a,offset:(i-1)*a}}function validateSort(e,i){let a=e.sortBy||i[0],t=(e.sortOrder||"DESC").toUpperCase();i.includes(a)||(a=i[0]);["ASC","DESC"].includes(t)||(t="DESC");return{sortBy:a,sortOrder:t}}async function checkMarketConflict(e,i,a){const{models:t}=await Promise.resolve().then(()=>__importStar(require("@b/db"))),{Op:o}=await Promise.resolve().then(()=>__importStar(require("sequelize"))),r=await t.copyTradingFollower.findAll({where:{userId:e,leaderId:{[o.ne]:i},status:{[o.in]:["ACTIVE","PAUSED"]}},include:[{model:t.copyTradingFollowerAllocation,as:"allocations",where:{symbol:{[o.in]:a},isActive:!0},required:!1},{model:t.copyTradingLeader,as:"leader",attributes:["displayName"]}]}),n=[];for(const e of r)e.allocations&&e.allocations.length>0&&n.push({leaderName:e.leader.displayName,markets:e.allocations.map(e=>e.symbol)});return n.length>0?{hasConflict:!0,conflictDetails:n}:{hasConflict:!1}}function throwValidationError(e){throw(0,error_1.createError)({statusCode:400,message:e.errors.join("; ")})}var __createBinding=this&&this.__createBinding||(Object.create?function(e,i,a,t){void 0===t&&(t=a);var o=Object.getOwnPropertyDescriptor(i,a);o&&!("get"in o?!i.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return i[a]}});Object.defineProperty(e,t,o)}:function(e,i,a,t){void 0===t&&(t=a);e[t]=i[a]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,i){Object.defineProperty(e,"default",{enumerable:!0,value:i})}:function(e,i){e.default=i}),__importStar=this&&this.__importStar||function(){var e=function(i){e=Object.getOwnPropertyNames||function(e){var i=[];for(var a in e)Object.prototype.hasOwnProperty.call(e,a)&&(i[i.length]=a);return i};return e(i)};return function(i){if(i&&i.__esModule)return i;var a={};if(null!=i)for(var t=e(i),o=0;o<t.length;o++)"default"!==t[o]&&__createBinding(a,i,t[o]);__setModuleDefault(a,i);return a}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.copyTradingRateLimiters=void 0;exports.isValidUUID=isValidUUID;exports.sanitizeString=sanitizeString;exports.validateNumber=validateNumber;exports.validateLeaderApplication=validateLeaderApplication;exports.validateFollowRequest=validateFollowRequest;exports.validateFundOperation=validateFundOperation;exports.validateSubscriptionUpdate=validateSubscriptionUpdate;exports.validateLeaderUpdate=validateLeaderUpdate;exports.validatePagination=validatePagination;exports.validateSort=validateSort;exports.checkMarketConflict=checkMarketConflict;exports.throwValidationError=throwValidationError;const Middleware_1=require("@b/handler/Middleware"),error_1=require("@b/utils/error"),index_1=require("./index"),redis_1=require("@b/utils/redis");exports.copyTradingRateLimiters={leaderApply:leaderApplyRateLimiter,leaderUpdate:(0,Middleware_1.createRateLimiter)({limit:10,window:3600,keyPrefix:"copytrading:leader:update",message:"Too many profile updates. Please wait before making more changes."}),followerFollow:(0,Middleware_1.createRateLimiter)({limit:10,window:3600,keyPrefix:"copytrading:follower:follow",message:"Too many follow requests. Please wait before following more leaders."}),followerAction:(0,Middleware_1.createRateLimiter)({limit:30,window:3600,keyPrefix:"copytrading:follower:action",message:"Too many subscription actions. Please slow down."}),fundManagement:(0,Middleware_1.createRateLimiter)({limit:20,window:3600,keyPrefix:"copytrading:funds",message:"Too many fund operations. Please wait before making more changes."}),tradeQuery:(0,Middleware_1.createRateLimiter)({limit:100,window:60,keyPrefix:"copytrading:trade:query",message:"Too many requests. Please slow down."}),analyticsQuery:(0,Middleware_1.createRateLimiter)({limit:30,window:60,keyPrefix:"copytrading:analytics",message:"Too many analytics requests. Please wait."}),wsSubscribe:(0,Middleware_1.createRateLimiter)({limit:50,window:60,keyPrefix:"copytrading:ws:subscribe",message:"Too many WebSocket subscriptions. Please wait."}),adminAction:(0,Middleware_1.createRateLimiter)({limit:50,window:3600,keyPrefix:"copytrading:admin",message:"Too many admin actions. Please wait."})};