"use strict";async function processTransaction(r,o,e,a,t,s,n,i){if(!(o&&e&&a&&t&&i)){console_1.logger.error("DEPOSIT",`Invalid parameters for processTransaction: txHash=${o}, address=${a}, chain=${t}, walletId=${i}`);return!1}try{console_1.logger.info("DEPOSIT",`Processing ${r} transaction ${o} on ${t}`);const c=await e.getTransaction(o);if(!c){console_1.logger.error("DEPOSIT",`Transaction ${o} not found on ${t}`);return!1}if(!c.data){console_1.logger.error("DEPOSIT",`Transaction ${o} has no data field`);return!1}const l=(0,blockchain_1.decodeTransactionData)(c.data),g=l.to||c.to,u=l.amount||c.value;if(!g||!a){console_1.logger.error("DEPOSIT",`Invalid transaction data for ${o}: realTo=${g}, address=${a}`);return!1}if(g.toLowerCase()!==a.toLowerCase()){console_1.logger.warn("DEPOSIT",`Address mismatch for ${o}: expected=${a}, actual=${g}`);return!1}if(!u||"0"===u.toString()){console_1.logger.warn("DEPOSIT",`Zero or invalid amount for transaction ${o}`);return!1}const d=await createTransactionDetails(r,i,c,g,t,s,n,"DEPOSIT",u);await(0,deposit_1.storeAndBroadcastTransaction)(d,o);console_1.logger.success("DEPOSIT",`Transaction ${o} processed successfully on ${t}`);return!0}catch(r){console_1.logger.error("DEPOSIT",`Error processing transaction ${o} on ${t}: ${r.message}`);return!1}}async function createTransactionDetails(r,o,e,a,t,s,n,i,c=e.amount){var l;try{if(!(r&&o&&e&&a&&t&&i))throw(0,error_1.createError)({statusCode:400,message:"Missing required parameters for createTransactionDetails"});(s<0||s>18)&&console_1.logger.warn("DEPOSIT",`Unusual decimals value: ${s} for chain ${t}`);(n<0||n>18)&&console_1.logger.warn("DEPOSIT",`Unusual fee decimals value: ${n} for chain ${t}`);let g="0";try{if(c&&"0"!==c.toString()){g=ethers_1.ethers.formatUnits(c.toString(),s);if(isNaN(parseFloat(g))||parseFloat(g)<=0){console_1.logger.warn("DEPOSIT",`Invalid formatted amount ${g} for transaction ${e.hash}`);g="0"}}}catch(r){console_1.logger.error("DEPOSIT",`Error formatting amount for transaction ${e.hash}: ${r.message}`);g="0"}let u="N/A";try{e.gasLimit&&(u=e.gasLimit.toString())}catch(r){console_1.logger.warn("DEPOSIT",`Error formatting gas limit for transaction ${e.hash}: ${r.message}`)}let d="N/A";try{if(e.gasPrice){d=ethers_1.ethers.formatUnits(e.gasPrice.toString(),n);if(isNaN(parseFloat(d))||parseFloat(d)<0){console_1.logger.warn("DEPOSIT",`Invalid gas price ${d} for transaction ${e.hash}`);d="N/A"}}}catch(r){console_1.logger.warn("DEPOSIT",`Error formatting gas price for transaction ${e.hash}: ${r.message}`)}const f={contractType:r,id:o,chain:t,hash:e.hash,type:i,from:e.from||"unknown",to:a,amount:g,gasLimit:u,gasPrice:d,timestamp:Math.floor(Date.now()/1e3),blockNumber:(null===(l=e.blockNumber)||void 0===l?void 0:l.toString())||"0",status:"PENDING"};console_1.logger.debug("DEPOSIT",`Created transaction details for ${e.hash}: amount=${g}, chain=${t}`);return f}catch(r){console_1.logger.error("DEPOSIT",`Error creating transaction details: ${r.message}`);throw r}}Object.defineProperty(exports,"__esModule",{value:!0});exports.processTransaction=processTransaction;exports.createTransactionDetails=createTransactionDetails;const ethers_1=require("ethers"),deposit_1=require("@b/api/(ext)/ecosystem/utils/redis/deposit"),blockchain_1=require("@b/api/(ext)/ecosystem/utils/blockchain"),console_1=require("@b/utils/console"),error_1=require("@b/utils/error");