"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.EVMDeposits=void 0;const tokens_1=require("@b/api/(ext)/ecosystem/utils/tokens"),transactions_1=require("@b/api/(ext)/ecosystem/utils/transactions"),chains_1=require("@b/api/(ext)/ecosystem/utils/chains"),ProviderManager_1=require("../ProviderManager"),ethers_1=require("ethers"),DepositUtils_1=require("../DepositUtils"),deposit_1=require("@b/api/(ext)/ecosystem/utils/redis/deposit"),console_1=require("@b/utils/console");class EVMDeposits{constructor(e){this.active=!0;this.wallet=e.wallet;this.chain=e.chain;this.currency=e.currency;this.address=e.address;this.contractType=e.contractType}async watchDeposits(){var e;if(this.active)try{let t=ProviderManager_1.chainProviders.get(this.chain);if(!t){t=await(0,ProviderManager_1.initializeWebSocketProvider)(this.chain);t||(t=await(0,ProviderManager_1.initializeHttpProvider)(this.chain));if(!t){console_1.logger.error("EVM_DEPOSIT",`No provider available for chain ${this.chain}`);return}}const s=(null===(e=chains_1.chainConfigs[this.chain])||void 0===e?void 0:e.decimals)||18;"NATIVE"===this.contractType?await this.watchNativeDeposits(t,s):await this.watchTokenDeposits(t,s)}catch(e){console_1.logger.error("EVM_DEPOSIT",`Error in watchDeposits for ${this.chain}: ${e.message}`);this.active=!1}else console_1.logger.debug("EVM_DEPOSIT",`Monitor for ${this.chain} is not active, skipping watchDeposits`)}async watchNativeDeposits(e,t){var s;const i=(null===(s=chains_1.chainConfigs[this.chain])||void 0===s?void 0:s.decimals)||18;let o=!1,r=Math.floor(Date.now()/1e3),n=0;console_1.logger.info("EVM_DEPOSIT",`Starting native deposit monitoring for ${this.chain} address ${this.address}`);const a=async()=>{if(!o&&this.active)try{const e=await(0,transactions_1.fetchEcosystemTransactions)(this.chain,this.address);for(const s of e)if(s.to&&s.to.toLowerCase()===this.address.toLowerCase()&&Number(s.timestamp)>r&&1===Number(s.status)){n=0;try{console_1.logger.success("EVM_DEPOSIT",`Found native deposit for ${this.chain}: ${s.hash}`);const e=await(0,DepositUtils_1.createTransactionDetails)("NATIVE",this.wallet.id,s,this.address,this.chain,i,t,"DEPOSIT");await(0,deposit_1.storeAndBroadcastTransaction)(e,s.hash);console_1.logger.success("EVM_DEPOSIT",`Native deposit ${s.hash} processed successfully - stopping monitor`);o=!0;this.stopPolling();return}catch(e){console_1.logger.error("EVM_DEPOSIT",`Error processing native transaction ${s.hash}: ${e.message}`)}r=Math.floor(Date.now()/1e3);break}n=0}catch(e){n++;console_1.logger.error("EVM_DEPOSIT",`${this.chain} Error fetching transactions (attempt ${n}/10)`);console_1.logger.error("EVM_DEPOSIT",`${this.chain} Error message: ${e.message}`);n<=3&&console_1.logger.debug("EVM_DEPOSIT",`${this.chain} Full error: ${JSON.stringify(e)}`);if(n>=10){console_1.logger.error("EVM_DEPOSIT",`${this.chain} Max consecutive errors (10) reached, stopping monitor`);this.stopPolling();return}}};await a();const c=()=>{if(0===n)return 1e4;const e=Math.min(1e4*Math.pow(2,n-1),6e4);console_1.logger.debug("EVM_DEPOSIT",`${this.chain} Next poll in ${e/1e3}s (${n} consecutive errors)`);return e},h=()=>{this.active&&!o?this.intervalId=setTimeout(async()=>{await a();h()},c()):o&&console_1.logger.info("EVM_DEPOSIT",`Native deposit found for ${this.chain}, stopping monitoring`)};h()}async watchTokenDeposits(e,t){try{const s=await(0,tokens_1.getEcosystemToken)(this.chain,this.currency);if(!s){console_1.logger.error("EVM_DEPOSIT",`Token ${this.currency} not found for chain ${this.chain}`);return}const i=s.decimals;console_1.logger.info("EVM_DEPOSIT",`Starting token deposit monitoring for ${this.currency} on ${this.chain} at address ${this.address}`);const o={address:s.contract,topics:[ethers_1.ethers.id("Transfer(address,address,uint256)"),null,this.address?ethers_1.ethers.zeroPadValue(this.address,32):void 0]};this.eventFilter=o;this.eventListener=async s=>{if(this.active)try{console_1.logger.info("EVM_DEPOSIT",`Token transfer event detected for ${this.currency} on ${this.chain}: ${s.transactionHash}`);if(await(0,DepositUtils_1.processTransaction)("NO_PERMIT"===this.contractType?"NO_PERMIT":"PERMIT",s.transactionHash,e,this.address,this.chain,i,t,this.wallet.id)){console_1.logger.success("EVM_DEPOSIT",`Token deposit ${s.transactionHash} processed successfully`);const e="NO_PERMIT"===this.contractType?3e5:18e5;setTimeout(()=>{this.stopEventListener();console_1.logger.info("EVM_DEPOSIT",`Token deposit monitoring stopped after ${e/1e3}s for ${this.chain}`)},e)}}catch(e){console_1.logger.error("EVM_DEPOSIT",`Error in token deposit handler for ${this.chain}: ${e.message}`)}else console_1.logger.debug("EVM_DEPOSIT",`Monitor inactive, ignoring event for ${this.chain}`)};e.on(o,this.eventListener);e.on("error",s=>{console_1.logger.error("EVM_DEPOSIT",`Provider error for ${this.chain}: ${s.message}`);if(e.websocket){console_1.logger.info("EVM_DEPOSIT",`Attempting to reconnect WebSocket provider for ${this.chain}`);setTimeout(async()=>{try{const s=await(0,ProviderManager_1.initializeWebSocketProvider)(this.chain);if(s&&this.active){e.removeAllListeners();await this.watchTokenDeposits(s,t)}}catch(e){console_1.logger.error("EVM_DEPOSIT",`Failed to reconnect provider for ${this.chain}: ${e.message}`)}},5e3)}});if(e.websocket){e.websocket.on("close",()=>{console_1.logger.warn("EVM_DEPOSIT",`WebSocket connection closed for ${this.chain}`)});e.websocket.on("open",()=>{console_1.logger.info("EVM_DEPOSIT",`WebSocket connection opened for ${this.chain}`)})}}catch(e){console_1.logger.error("EVM_DEPOSIT",`Error setting up token deposit monitoring for ${this.chain}: ${e.message}`);this.active=!1}}stopEventListener(){if(this.eventListener&&this.eventFilter){const e=ProviderManager_1.chainProviders.get(this.chain);if(e)try{e.off(this.eventFilter,this.eventListener);console_1.logger.debug("EVM_DEPOSIT",`Event listener removed for ${this.chain}`)}catch(e){console_1.logger.error("EVM_DEPOSIT",`Error removing event listener for ${this.chain}: ${e.message}`)}this.eventListener=null;this.eventFilter=null}}stopPolling(){console_1.logger.info("EVM_DEPOSIT",`Stopping EVM deposit monitoring for ${this.chain}`);this.active=!1;if(this.intervalId){clearTimeout(this.intervalId);this.intervalId=void 0}this.stopEventListener();console_1.logger.success("EVM_DEPOSIT",`EVM deposit monitoring stopped for ${this.chain}`)}}exports.EVMDeposits=EVMDeposits;