"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,r,t,s){void 0===s&&(s=t);var i=Object.getOwnPropertyDescriptor(r,t);i&&!("get"in i?!r.__esModule:i.writable||i.configurable)||(i={enumerable:!0,get:function(){return r[t]}});Object.defineProperty(e,s,i)}:function(e,r,t,s){void 0===s&&(s=t);e[s]=r[t]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,r){Object.defineProperty(e,"default",{enumerable:!0,value:r})}:function(e,r){e.default=r}),__importStar=this&&this.__importStar||function(){var e=function(r){e=Object.getOwnPropertyNames||function(e){var r=[];for(var t in e)Object.prototype.hasOwnProperty.call(e,t)&&(r[r.length]=t);return r};return e(r)};return function(r){if(r&&r.__esModule)return r;var t={};if(null!=r)for(var s=e(r),i=0;i<s.length;i++)"default"!==s[i]&&__createBinding(t,r,s[i]);__setModuleDefault(t,r);return t}}();Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const query_1=require("@b/utils/query"),utils_1=require("./utils"),error_1=require("@b/utils/error"),queries_1=require("@b/api/(ext)/ecosystem/utils/scylla/queries");exports.metadata={summary:"List Orders",operationId:"listOrders",tags:["Exchange","Orders"],description:"Retrieves a list of orders for the authenticated user.",logModule:"ECOSYSTEM",logTitle:"List user orders",parameters:[{name:"type",in:"query",description:"Type of order to retrieve.",schema:{type:"string"}},{name:"symbol",in:"query",description:"Symbol of the order to retrieve.",schema:{type:"string"}}],responses:{200:{description:"A list of orders",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseOrderSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Order"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:r,ctx:t,query:s}=e;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const{currency:i,pair:o,type:n}=s;if(!(null==r?void 0:r.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});if(!i||!o){null==t||t.step("Fetching all user orders");const{getOrdersByUserId:e}=await Promise.resolve().then(()=>__importStar(require("@b/api/(ext)/ecosystem/utils/scylla/queries")));try{const s=await e(r.id);null==t||t.step(`Filtering orders by status: ${n||"all"}`);const i=s.filter(e=>"OPEN"===n?"OPEN"===e.status:"OPEN"!==e.status);null==t||t.step("Converting bigint fields to numbers");const o=i.map(e=>{const{fromBigInt:r}=require("@b/api/(ext)/ecosystem/utils/blockchain");return{...e,amount:r(e.amount),price:r(e.price),cost:r(e.cost),fee:r(e.fee),filled:r(e.filled),remaining:r(e.remaining)}});null==t||t.success(`Retrieved ${o.length} orders`);return o}catch(e){null==t||t.fail(`Failed to fetch orders: ${e.message}`);console.error("[Ecosystem Orders] Error fetching orders:",e);throw e}}null==t||t.step(`Fetching orders for ${i}/${o}`);const u=await(0,queries_1.getOrders)(r.id,`${i}/${o}`,"OPEN"===n);null==t||t.success(`Retrieved ${(null==u?void 0:u.length)||0} orders for ${i}/${o}`);return u};