"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.MempoolProvider=void 0;const console_1=require("@b/utils/console"),error_1=require("@b/utils/error");class MempoolProvider{constructor(e){this.timeout=3e4;this.chain=e;this.baseURL=this.getBaseURL(e)}getBaseURL(e){const t={BTC:"testnet"===process.env.BTC_NETWORK?"https://mempool.space/testnet/api":"https://mempool.space/api",LTC:"https://litecoinspace.org/api"};if(!t[e])throw(0,error_1.createError)({statusCode:400,message:`Mempool provider not available for ${e}`});return t[e]}getName(){return`Mempool.space (${this.chain})`}async fetchFromAPI(e,t={}){const s=`${this.baseURL}${e}`;try{const e=await fetch(s,{...t,signal:AbortSignal.timeout(this.timeout)});if(!e.ok)throw(0,error_1.createError)({statusCode:e.status,message:`HTTP ${e.status}: ${e.statusText}`});const r=e.headers.get("content-type");return(null==r?void 0:r.includes("application/json"))?await e.json():await e.text()}catch(e){throw this.enhanceError(e,s)}}enhanceError(e,t){var s,r,o,a;let c=(null==e?void 0:e.message)||"Unknown error";const i=[];if(null==e?void 0:e.cause){const t=e.cause;t.code&&i.push(`code: ${t.code}`);t.syscall&&i.push(`syscall: ${t.syscall}`);t.hostname&&i.push(`host: ${t.hostname}`);t.message&&t.message!==c&&(c=t.message);(null===(s=t.cause)||void 0===s?void 0:s.message)&&(c=t.cause.message)}"TimeoutError"===(null==e?void 0:e.name)||c.includes("timeout")?c=`Request timed out after ${this.timeout}ms`:"ENOTFOUND"===(null==e?void 0:e.code)||"ENOTFOUND"===(null===(r=null==e?void 0:e.cause)||void 0===r?void 0:r.code)?c="DNS lookup failed - host not found":"ECONNREFUSED"===(null==e?void 0:e.code)||"ECONNREFUSED"===(null===(o=null==e?void 0:e.cause)||void 0===o?void 0:o.code)?c="Connection refused":"ECONNRESET"===(null==e?void 0:e.code)||"ECONNRESET"===(null===(a=null==e?void 0:e.cause)||void 0===a?void 0:a.code)?c="Connection reset by server":("CERT_HAS_EXPIRED"===(null==e?void 0:e.code)||c.includes("certificate"))&&(c="SSL certificate error");const n=t.replace(this.baseURL,""),u=i.length>0?` (${i.join(", ")})`:"",l=new Error(`${c}${u} [${n}]`);l.name=(null==e?void 0:e.name)||"FetchError";return l}async fetchTransactions(e){try{const t=await this.fetchFromAPI(`/address/${e}/txs`),s=await this.getCurrentBlockHeight();return t.map(t=>{const r=t.status.confirmed?s-t.status.block_height+1:0;let o=0;t.vout.forEach(t=>{t.scriptpubkey_address===e&&(o+=t.value)});return{hash:t.txid,blockHeight:t.status.block_height,value:o,confirmedTime:t.status.block_time?new Date(1e3*t.status.block_time).toISOString():void 0,spent:!1,confirmations:r,fee:t.fee}})}catch(t){console_1.logger.error("MEMPOOL",`fetchTransactions(${e.slice(0,8)}...)`,t);return[]}}async fetchTransaction(e){try{const t=await this.fetchFromAPI(`/tx/${e}`),s=await this.getCurrentBlockHeight(),r=t.status.confirmed?s-t.status.block_height+1:0,o=t.vin.map(e=>{var t,s,r;return{prev_hash:e.txid,prevHash:e.txid,output_index:e.vout,outputIndex:e.vout,output_value:(null===(t=e.prevout)||void 0===t?void 0:t.value)||0,addresses:(null===(s=e.prevout)||void 0===s?void 0:s.scriptpubkey_address)?[e.prevout.scriptpubkey_address]:[],script:null===(r=e.prevout)||void 0===r?void 0:r.scriptpubkey}}),a=t.vout.map(e=>({value:e.value,addresses:e.scriptpubkey_address?[e.scriptpubkey_address]:[],script:e.scriptpubkey,spent:e.spent||!1,spent_by:e.spent_by,spender:e.spent_by}));return{hash:t.txid,block_height:t.status.block_height,confirmations:r,fee:t.fee,inputs:o,outputs:a}}catch(t){console_1.logger.error("MEMPOOL",`fetchTransaction(${e.slice(0,8)}...)`,t);return null}}async fetchRawTransaction(e){try{return await this.fetchFromAPI(`/tx/${e}/hex`)}catch(t){console_1.logger.error("MEMPOOL",`fetchRawTransaction(${e.slice(0,8)}...)`,t);throw t}}async getBalance(e){try{const t=await this.fetchFromAPI(`/address/${e}`),s=t.chain_stats.funded_txo_sum||0;return s-(t.chain_stats.spent_txo_sum||0)}catch(t){console_1.logger.error("MEMPOOL",`getBalance(${e.slice(0,8)}...)`,t);return 0}}async getUTXOs(e){try{const t=await this.fetchFromAPI(`/address/${e}/utxo`),s=await this.getCurrentBlockHeight();return t.map(e=>({txid:e.txid,vout:e.vout,value:e.value,confirmations:e.status.confirmed?s-e.status.block_height+1:0,script:e.scriptpubkey}))}catch(t){console_1.logger.error("MEMPOOL",`getUTXOs(${e.slice(0,8)}...)`,t);return[]}}async broadcastTransaction(e){try{return{success:!0,txid:await this.fetchFromAPI("/tx",{method:"POST",headers:{"Content-Type":"text/plain"},body:e})}}catch(e){console_1.logger.error("MEMPOOL","broadcastTransaction",e);return{success:!1,txid:null,error:e.message}}}async getFeeRate(){try{const e=await this.fetchFromAPI("/v1/fees/recommended");return e[process.env.BTC_FEE_RATE_PRIORITY||"halfHourFee"]||e.halfHourFee||e.fastestFee}catch(e){console_1.logger.error("MEMPOOL","getFeeRate",e);return 1}}async getCurrentBlockHeight(){try{const e=await this.fetchFromAPI("/blocks/tip/height");return parseInt(e)}catch(e){console_1.logger.error("MEMPOOL","getCurrentBlockHeight",e);return 0}}async isAvailable(){try{await this.fetchFromAPI("/blocks/tip/height");return!0}catch(e){return!1}}}exports.MempoolProvider=MempoolProvider;