"use strict";async function getUTXOProvider(e){return UTXOProviderFactory.getProvider(e)}Object.defineProperty(exports,"__esModule",{value:!0});exports.UTXOProviderFactory=void 0;exports.getUTXOProvider=getUTXOProvider;const MempoolProvider_1=require("./MempoolProvider"),BlockCypherProvider_1=require("./BlockCypherProvider"),BitcoinNodeProvider_1=require("./BitcoinNodeProvider"),error_1=require("@b/utils/error");class UTXOProviderFactory{static async getProvider(e){const r=e;if(this.instances.has(r))return this.instances.get(r);const o=this.getProviderType(e),i=await this.createProvider(e,o);this.instances.set(r,i);return i}static getProviderType(e){var r;const o=`${e}_NODE`,i=null===(r=process.env[o])||void 0===r?void 0:r.toLowerCase();if("mempool"===i||"blockcypher"===i||"node"===i)return i;return{BTC:"mempool",LTC:"mempool",DOGE:"blockcypher",DASH:"blockcypher"}[e]||"blockcypher"}static async createProvider(e,r){console.log(`[UTXO_PROVIDER] Creating ${r} provider for ${e}`);switch(r){case"mempool":if(!["BTC","LTC"].includes(e)){console.warn(`[UTXO_PROVIDER] Mempool doesn't support ${e}, falling back to BlockCypher`);return new BlockCypherProvider_1.BlockCypherProvider(e)}return new MempoolProvider_1.MempoolProvider(e);case"blockcypher":return new BlockCypherProvider_1.BlockCypherProvider(e);case"node":if("BTC"!==e){console.warn(`[UTXO_PROVIDER] Bitcoin Node only supports BTC, falling back to BlockCypher for ${e}`);return new BlockCypherProvider_1.BlockCypherProvider(e)}const o=new BitcoinNodeProvider_1.BitcoinNodeProvider(e);await o.initialize();if(!await o.isAvailable()){console.warn("[UTXO_PROVIDER] Bitcoin Node is not available or not synced, falling back to Mempool");return new MempoolProvider_1.MempoolProvider(e)}return o;default:throw(0,error_1.createError)({statusCode:400,message:`Unknown provider type: ${r}`})}}static clearCache(e){e?this.instances.delete(e):this.instances.clear()}static async getAvailableProviders(e){const r=["mempool","blockcypher","node"],o=[];for(const i of r)try{const r=await this.createProvider(e,i),t=await r.isAvailable();o.push({type:i,available:t,name:r.getName()})}catch(r){o.push({type:i,available:!1,name:`${i} (${e})`})}return o}}exports.UTXOProviderFactory=UTXOProviderFactory;UTXOProviderFactory.instances=new Map;