"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),utils_1=require("./utils");exports.metadata={summary:"Retrieves active Forex investments for the logged-in user",description:"Fetches active Forex investments associated with the currently authenticated user.",operationId:"getActiveForexInvestments",tags:["Forex","Investments"],logModule:"FOREX",logTitle:"Get Active Investments",responses:{200:{description:"Active Forex investments retrieved successfully",content:{"application/json":{schema:{type:"array",items:{type:"object",properties:utils_1.baseForexInvestmentSchema}}}}},401:query_1.unauthorizedResponse,404:(0,query_1.notFoundMetadataResponse)("Forex Investment"),500:query_1.serverErrorResponse},requiresAuth:!0};exports.default=async e=>{const{user:t,ctx:s}=e;null==s||s.step("Fetching Active Investments");if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"});const r=await db_1.models.forexInvestment.findAll({where:{userId:t.id,status:"ACTIVE"},include:[{model:db_1.models.forexPlan,as:"plan",attributes:["id","name","title","description","profitPercentage","image"]},{model:db_1.models.user,as:"user",attributes:["id","avatar","firstName","lastName"]},{model:db_1.models.forexDuration,as:"duration",attributes:["id","duration","timeframe"]}]});null==s||s.success("Get Active Investments fetched successfully");return r};