"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const error_1=require("@b/utils/error"),query_1=require("@b/utils/query"),order_1=require("@b/api/(ext)/futures/utils/queries/order");exports.metadata={summary:"Cancel all futures orders",description:"Cancels all open futures orders for the authenticated user.",operationId:"cancelAllFuturesOrders",tags:["Futures","Orders"],logModule:"FUTURES",logTitle:"Cancel all futures orders",responses:(0,query_1.createRecordResponses)("Orders cancelled"),requiresAuth:!0};exports.default=async e=>{var r,l,s,t,o;const{user:u,ctx:a}=e;null===(r=null==a?void 0:a.step)||void 0===r||r.call(a,"Validating user authentication");if(!(null==u?void 0:u.id)){null===(l=null==a?void 0:a.fail)||void 0===l||l.call(a,"User not authenticated");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}try{null===(s=null==a?void 0:a.step)||void 0===s||s.call(a,`Cancelling all open futures orders for user ${u.id}`);const e=await(0,order_1.cancelAllOrdersByUserId)(u.id);null===(t=null==a?void 0:a.success)||void 0===t||t.call(a,`Cancelled ${e.cancelledCount||0} futures orders`);return{message:"All futures orders cancelled successfully",cancelledCount:e.cancelledCount||0}}catch(e){console.error("Error cancelling all futures orders:",e);null===(o=null==a?void 0:a.fail)||void 0===o||o.call(a,`Failed to cancel orders: ${e.message}`);throw(0,error_1.createError)({statusCode:500,message:`Failed to cancel all futures orders: ${e.message}`})}};