"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=void 0;const db_1=require("@b/db"),error_1=require("@b/utils/error"),gateway_1=require("@b/utils/gateway");exports.metadata={summary:"Create API key pair",description:"Creates a new API key pair (public + secret) for the merchant.",operationId:"createApiKey",tags:["Gateway","Merchant","API Keys"],requestBody:{required:!0,content:{"application/json":{schema:{type:"object",properties:{name:{type:"string",description:"Key name/label"},type:{type:"string",enum:["LIVE","TEST"],description:"Key mode (LIVE or TEST)"},successUrl:{type:"string",format:"uri",description:"Success redirect URL"},cancelUrl:{type:"string",format:"uri",description:"Cancel redirect URL"},webhookUrl:{type:"string",format:"uri",description:"Webhook URL for notifications"},permissions:{type:"array",items:{type:"string"},description:"List of permissions for the key. Use '*' for full access, or specific permissions like 'payment.create', 'payment.read', 'payment.cancel', 'refund.create', 'refund.read'"},allowedWalletTypes:{type:"object",description:"Allowed wallet types and currencies for this API key",additionalProperties:{type:"object",properties:{enabled:{type:"boolean"},currencies:{type:"array",items:{type:"string"}}}}},ipWhitelist:{type:"array",items:{type:"string"},nullable:!0,description:"List of IP addresses or CIDR ranges allowed to use this API key. Only applies to secret keys (sk_*). Supports IPv4/IPv6 and CIDR notation (e.g., '192.168.1.0/24'). Use '*' to allow all IPs. Set to null to allow all."}},required:["name","type"]}}}},responses:{201:{description:"API key pair created"},400:{description:"Invalid request"}},requiresAuth:!0,logModule:"GATEWAY",logTitle:"Create API key pair"};exports.default=async e=>{const{user:t,body:r,ctx:a}=e;null==a||a.step("Validate user authentication");if(!(null==t?void 0:t.id)){null==a||a.fail("Unauthorized - no user ID");null==a||a.fail("Unauthorized - no user ID");throw(0,error_1.createError)({statusCode:401,message:"Unauthorized"})}null==a||a.step("Find merchant account");const s=await db_1.models.gatewayMerchant.findOne({where:{userId:t.id}});if(!s){null==a||a.fail("Merchant account not found");null==a||a.fail("Merchant account not found");throw(0,error_1.createError)({statusCode:404,message:"Merchant account not found"})}null==a||a.step("Validate merchant status and verification");if("ACTIVE"!==s.status){null==a||a.fail("Merchant account is not active");null==a||a.fail("Merchant account is not active");throw(0,error_1.createError)({statusCode:403,message:"Merchant account is not active. Please wait for approval."})}if("VERIFIED"!==s.verificationStatus){null==a||a.fail("Merchant account is not verified");null==a||a.fail("Merchant account is not verified");throw(0,error_1.createError)({statusCode:403,message:"Merchant account must be verified to create API keys. Please complete the verification process first."})}null==a||a.step("Validate request fields");if(!r.name||!r.type){null==a||a.fail("Missing required fields");null==a||a.fail("Missing required fields");throw(0,error_1.createError)({statusCode:400,message:"Missing required fields: name, type"})}const i=r.type;if(!["LIVE","TEST"].includes(i)){null==a||a.fail("Invalid key type");null==a||a.fail("Invalid key type");throw(0,error_1.createError)({statusCode:400,message:"Type must be LIVE or TEST"})}null==a||a.step("Check API key limit");if(await db_1.models.gatewayApiKey.count({where:{merchantId:s.id}})>=10){null==a||a.fail("Maximum number of API keys reached");null==a||a.fail("Maximum number of API keys reached");throw(0,error_1.createError)({statusCode:400,message:"Maximum number of API keys reached (10)"})}null==a||a.step("Generate API key pair");const l="LIVE"===i?"pk_live_":"pk_test_",n="LIVE"===i?"sk_live_":"sk_test_",o=(0,gateway_1.generateApiKey)(l),c=(0,gateway_1.generateApiKey)(n);null==a||a.step("Validate and set permissions");const u=["*","payment.create","payment.read","payment.cancel","refund.create","refund.read"];let d=r.permissions||["*"];Array.isArray(d)||(d=["*"]);d=d.filter(e=>u.includes(e));0===d.length&&(d=["*"]);null==a||a.step("Process IP whitelist");let p=null;if(r.ipWhitelist&&Array.isArray(r.ipWhitelist)){const e=r.ipWhitelist.map(e=>null==e?void 0:e.trim()).filter(e=>e&&e.length>0);p=e.length>0?e:null}null==a||a.step("Create public and secret API keys");const y=await db_1.models.gatewayApiKey.create({merchantId:s.id,name:`${r.name} (Public)`,keyPrefix:l,keyHash:(0,gateway_1.hashApiKey)(o),lastFourChars:(0,gateway_1.getLastFourChars)(o),type:"PUBLIC",mode:i,permissions:d,allowedWalletTypes:r.allowedWalletTypes||null,successUrl:r.successUrl||null,cancelUrl:r.cancelUrl||null,webhookUrl:r.webhookUrl||null,status:!0}),m=await db_1.models.gatewayApiKey.create({merchantId:s.id,name:`${r.name} (Secret)`,keyPrefix:n,keyHash:(0,gateway_1.hashApiKey)(c),lastFourChars:(0,gateway_1.getLastFourChars)(c),type:"SECRET",mode:i,permissions:d,allowedWalletTypes:r.allowedWalletTypes||null,ipWhitelist:p,successUrl:r.successUrl||null,cancelUrl:r.cancelUrl||null,webhookUrl:r.webhookUrl||null,status:!0});null==a||a.success("API key pair created successfully");null==a||a.success("API key pair created successfully");return{publicKey:o,secretKey:c,keys:[{id:y.id,name:y.name,keyPreview:`${l}...${y.lastFourChars}`,type:y.type,mode:y.mode},{id:m.id,name:m.name,keyPreview:`${n}...${m.lastFourChars}`,type:m.type,mode:m.mode}],note:"Save these keys securely. They will not be shown again."}};