"use strict";Object.defineProperty(exports,"__esModule",{value:!0});exports.metadata=exports.offeringCreationSchema=void 0;const utils_1=require("@b/api/finance/wallet/utils"),notifications_1=require("@b/utils/notifications"),db_1=require("@b/db"),error_1=require("@b/utils/error"),Middleware_1=require("@b/handler/Middleware");exports.offeringCreationSchema={type:"object",properties:{name:{type:"string",minLength:2},icon:{type:"string",description:"Token icon URL"},symbol:{type:"string",minLength:2,maxLength:8},tokenType:{type:"string"},blockchain:{type:"string"},totalSupply:{type:"number"},description:{type:"string",minLength:50,maxLength:1e3},tokenDetails:{type:"object",properties:{whitepaper:{type:"string",format:"uri"},github:{type:"string",description:"GitHub repository URL",format:"uri"},twitter:{type:"string",description:"Twitter handle or URL",format:"uri"},telegram:{type:"string",description:"Telegram handle or URL",format:"uri"},useOfFunds:{type:"array",items:{type:"string"}}},required:["whitepaper","github","useOfFunds","twitter","telegram"]},teamMembers:{type:"array",description:"Team members information",items:{type:"object",properties:{id:{type:"string"},name:{type:"string",description:"Member name"},role:{type:"string",description:"Member role"},bio:{type:"string",description:"Member bio",maxLength:500},linkedin:{type:"string",description:"LinkedIn URL",format:"uri"},twitter:{type:"string",description:"Twitter URL",format:"uri"},github:{type:"string",description:"GitHub URL",format:"uri"},website:{type:"string",description:"Website URL",format:"uri"}},required:["name","role","bio"]}},roadmap:{type:"array",description:"Roadmap items",items:{type:"object",properties:{id:{type:"string"},title:{type:"string"},description:{type:"string",maxLength:1e3},date:{type:"string",format:"date-time"},completed:{type:"boolean"}},required:["title","description","date"]}},website:{type:"string",description:"Project website URL",format:"uri"},targetAmount:{type:"number"},startDate:{type:"string",description:"Start date of the offering",format:"date-time"},phases:{type:"array",description:"Offering phases",items:{type:"object",properties:{id:{type:"string"},name:{type:"string"},tokenPrice:{type:"number"},allocation:{type:"number"},durationDays:{type:"number"}},required:["name","tokenPrice","allocation","durationDays"]}},vestingEnabled:{type:"boolean",description:"Enable token vesting"},vestingSchedule:{type:"object",description:"Vesting schedule configuration",properties:{type:{type:"string",enum:["LINEAR","CLIFF","MILESTONE"]},durationMonths:{type:"number"},cliffMonths:{type:"number"},milestones:{type:"array",items:{type:"object",properties:{monthsAfterPurchase:{type:"number"},percentage:{type:"number"}}}}}},termsAccepted:{type:"boolean"},selectedPlan:{type:"string",description:"ID of the selected launch plan",pattern:"^[0-9a-fA-F-]{36}$"},paymentComplete:{type:"boolean"}},required:["name","symbol","icon","tokenType","blockchain","totalSupply","description","tokenDetails","website","targetAmount","startDate","phases","termsAccepted","selectedPlan","paymentComplete"]};exports.metadata={summary:"Create ICO Offering",description:"Creates a new ICO offering along with token details, team members, and roadmap items. Also verifies user wallet balance and deducts the launch fee based on the selected launch plan.",operationId:"createIcoOffering",tags:["ICO","Offerings"],requiresAuth:!0,logModule:"ICO_CREATE",logTitle:"Create ICO offering",requestBody:{required:!0,content:{"application/json":{schema:exports.offeringCreationSchema}}},responses:{200:{description:"ICO offering created successfully.",content:{"application/json":{schema:{type:"object",properties:{offering:{type:"object",description:"The created offering record"}}}}}},401:{description:"Unauthorized – Admin privileges required."},400:{description:"Bad Request"},500:{description:"Internal Server Error"}}};exports.default=async e=>{await Middleware_1.rateLimiters.orderCreation(e);const{user:t,body:r,ctx:a}=e;if(!(null==t?void 0:t.id))throw(0,error_1.createError)({statusCode:401,message:"Unauthorized: You must be logged in to create an offering."});null==a||a.step("Validating offering creation request");const{name:i,symbol:n,icon:o,tokenType:s,blockchain:l,totalSupply:c,description:d,tokenDetails:p,teamMembers:m,roadmap:u,website:f,targetAmount:g,startDate:y,phases:b,vestingEnabled:h,vestingSchedule:w,termsAccepted:C,selectedPlan:k,paymentComplete:I}=r;if(!C)throw(0,error_1.createError)({statusCode:400,message:"Terms and conditions must be accepted to create an offering."});null==a||a.step("Retrieving and validating launch plan");const _=await db_1.models.icoLaunchPlan.findOne({where:{id:k}});if(!_)throw(0,error_1.createError)({statusCode:400,message:"Invalid launch plan selected."});let O;try{O=JSON.parse(_.features)}catch(e){throw(0,error_1.createError)({statusCode:500,message:"Failed to parse launch plan features."})}if(m&&m.length>O.maxTeamMembers)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed team members is ${O.maxTeamMembers}.`});if(u&&u.length>O.maxRoadmapItems)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed roadmap items is ${O.maxRoadmapItems}.`});if(b&&b.length>O.maxOfferingPhases)throw(0,error_1.createError)({statusCode:400,message:`Maximum allowed offering phases is ${O.maxOfferingPhases}.`});if(!s)throw(0,error_1.createError)({statusCode:400,message:"Token type is required."});if(!/^[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$/i.test(s))throw(0,error_1.createError)({statusCode:400,message:"Invalid token type ID format. Please provide a valid UUID."});null==a||a.step("Validating token type");const T=await db_1.models.icoTokenType.findOne({where:{id:s}});if(!T)throw(0,error_1.createError)({statusCode:400,message:`Token type with ID ${s} not found.`});null==a||a.step("Verifying wallet balance for launch fee");const E=await(0,utils_1.getWallet)(t.id,_.walletType,_.currency,!1,a);if(!E||E.balance<_.price)throw(0,error_1.createError)({statusCode:400,message:"Insufficient balance for the launch."});const v=await db_1.sequelize.transaction();try{null==a||a.step("Creating ICO offering record");const e=new Date(y);let r=0;for(const e of b)r+=e.durationDays;const C=new Date(e);C.setDate(C.getDate()+r);const k=b.length>0?b[0].tokenPrice:0,I=await db_1.models.icoTokenOffering.create({userId:t.id,planId:_.id,typeId:T.id,name:i,icon:o,symbol:n.toUpperCase(),status:"PENDING",purchaseWalletCurrency:_.currency,purchaseWalletType:_.walletType,tokenPrice:k,targetAmount:g,startDate:e,endDate:C,participants:0,isPaused:!1,isFlagged:!1,submittedAt:new Date,website:f},{transaction:v});null==a||a.step("Creating token details and vesting configuration");await db_1.models.icoTokenDetail.create({offeringId:I.id,tokenType:s,totalSupply:c,tokensForSale:c,salePercentage:0,blockchain:l,description:d,useOfFunds:p.useOfFunds,links:[{label:"whitepaper",url:p.whitepaper},{label:"github",url:p.github},{label:"twitter",url:p.twitter},{label:"telegram",url:p.telegram}],vestingEnabled:h||!1,vestingSchedule:h?w:null},{transaction:v});null==a||a.step("Creating offering phases");for(let e=0;e<b.length;e++){const t=b[e];await db_1.models.icoTokenOfferingPhase.create({offeringId:I.id,name:t.name,tokenPrice:t.tokenPrice,allocation:t.allocation,duration:t.durationDays,remaining:t.allocation,sequence:e},{transaction:v})}null==a||a.step("Adding team members and roadmap items");if(Array.isArray(m))for(const e of m)e.name&&e.role&&e.bio&&await db_1.models.icoTeamMember.create({offeringId:I.id,name:e.name,role:e.role,bio:e.bio,avatar:e.avatar,linkedin:e.linkedin,twitter:e.twitter,website:e.website,github:e.github},{transaction:v});if(Array.isArray(u))for(const e of u)e.title&&e.description&&e.date&&await db_1.models.icoRoadmapItem.create({offeringId:I.id,title:e.title,description:e.description,date:e.date,completed:e.completed||!1},{transaction:v});null==a||a.step("Deducting launch fee from wallet");const O=await db_1.models.wallet.findOne({where:{id:E.id},transaction:v,lock:v.LOCK.UPDATE});if(!O)throw(0,error_1.createError)({statusCode:404,message:"Wallet not found during transaction."});if(O.balance<_.price)throw(0,error_1.createError)({statusCode:400,message:"Insufficient wallet balance at transaction time."});await O.update({balance:O.balance-_.price},{transaction:v});await v.commit();null==a||a.step("Sending confirmation notification");try{await(0,notifications_1.createNotification)({userId:t.id,relatedId:I.id,title:"Offering Created",type:"system",message:`Your ICO offering "${I.name}" has been created successfully.`,details:"Your offering is now pending review. You can track its progress and view more details on your dashboard.",link:`/ico/creator/token/${I.id}`,actions:[{label:"View Offering",link:`/ico/creator/token/${I.id}`,primary:!0}]},a)}catch(e){console.error("Failed to create notification for offering creation",e)}null==a||a.success(`Created ICO offering "${i}" (${n})`);return{message:"Offering created successfully."}}catch(e){await v.rollback();null==a||a.fail(e.message||"Failed to create ICO offering");throw(0,error_1.createError)({statusCode:500,message:"Internal Server Error: "+e.message})}};